/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops;

import io.fabric8.utils.Strings;
import java.util.Objects;

public class ProjectRepository {
    private String kind;
    private String url;
    private String gitUrl;
    private String repoName;
    private String user;

    public String toString() {
        return "ProjectRepository{kind='" + this.kind + '\'' + ", user='" + this.getUser() + '\'' + ", repoName='" + this.getRepoName() + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getGitUrl() {
        if (Strings.isNullOrBlank((String)this.gitUrl) && Strings.isNotBlank((String)this.url) && this.isGitHubProject()) {
            this.gitUrl = this.url + ".git";
        }
        return this.gitUrl;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public String getRepoName() {
        if (this.repoName == null) {
            this.extractOrganisationAndUserFromUrl();
        }
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getUser() {
        if (this.user == null) {
            this.extractOrganisationAndUserFromUrl();
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isGitHubProject() {
        return Objects.equals(this.getKind(), "GitHubProjectRepository");
    }

    protected void extractOrganisationAndUserFromUrl() {
        if (Strings.isNotBlank((String)this.url)) {
            String text = Strings.stripSuffix((String)this.url, (String)"./");
            text = Strings.stripSuffix((String)text, (String)".git");
            String[] split = (text = Strings.stripSuffix((String)text, (String)"/")).split("/");
            if (split != null && split.length > 1) {
                if (Strings.isNullOrBlank((String)this.user)) {
                    this.user = split[split.length - 2];
                }
                if (Strings.isNullOrBlank((String)this.repoName)) {
                    this.repoName = split[split.length - 1];
                }
            }
        }
    }

    public static class Kinds {
        public static final String GITHUB = "GitHubProjectRepository";
    }
}

