/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops.connector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.devops.ProjectRepositories;
import io.fabric8.devops.connector.WebHooks;
import io.fabric8.gerrit.CreateRepositoryDTO;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.letschat.LetsChatClient;
import io.fabric8.letschat.LetsChatKubernetes;
import io.fabric8.letschat.RoomDTO;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.GitRepoKubernetes;
import io.fabric8.taiga.ModuleDTO;
import io.fabric8.taiga.ProjectDTO;
import io.fabric8.taiga.TaigaClient;
import io.fabric8.taiga.TaigaKubernetes;
import io.fabric8.taiga.TaigaModule;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.URLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DevOpsConnector {
    private transient Logger log = LoggerFactory.getLogger(DevOpsConnector.class);
    private static final String JSON_MAGIC = ")]}'";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private File basedir;
    private ProjectConfig projectConfig;
    private String username;
    private String password;
    private String branch;
    private String repoName;
    private String fullName;
    private String gitUrl;
    private String secret = "secret101";
    private String buildImageStream = "triggerJenkins";
    private String buildImageTag = "latest";
    private String s2iCustomBuilderImage = "fabric8/openshift-s2i-jenkins-trigger";
    private String jenkinsJob;
    private boolean triggerJenkinsJob = true;
    private String jenkinsMonitorView;
    private String jenkinsPipelineView;
    private String taigaProjectName;
    private String taigaProjectSlug;
    private String taigaProjectLinkPage = "backlog";
    private String taigaProjectLinkLabel = "Backlog";
    private String issueTrackerUrl;
    private String issueTrackerLabel = "Issues";
    private String teamUrl;
    private String teamLabel = "Team";
    private String releasesUrl;
    private String releasesLabel = "Releases";
    private String repositoryBrowseLink;
    private String repositoryBrowseLabel = "Repository";
    private String taigaTeamLinkPage = "team";
    private String taigaTeamLinkLabel = "Team";
    private boolean taigaAutoCreate = true;
    private boolean taigaEnabled = true;
    private boolean letschatEnabled = true;
    private String letschatRoomLinkLabel = "Room";
    private String letschatRoomExpression = "fabric8_${namespace}";
    private String flowGitUrl = Systems.getEnvVar((String)"JENKINS_WORKFLOW_GIT_REPOSITORY", (String)"https://github.com/fabric8io/jenkins-workflow-library.git");
    private String gerritUser = Systems.getEnvVar((String)"GERRIT_ADMIN_USER", (String)"admin");
    private String gerritPwd = Systems.getEnvVar((String)"GERRIT_ADMIN_PWD", (String)"secret");
    private String gerritGitInitialCommit = Systems.getEnvVar((String)"GERRIT_INITIAL_COMMIT", (String)"false");
    private String gerritGitRepoDesription = Systems.getEnvVar((String)"GERRIT_REPO_DESCRIPTION", (String)"Description of the gerrit git repo");
    private boolean recreateMode;
    private String namespace = KubernetesHelper.defaultNamespace();
    private String projectName;
    private String fabric8ConsoleNamespace = KubernetesHelper.defaultNamespace();
    private String jenkinsNamespace = KubernetesHelper.defaultNamespace();
    private boolean tryLoadConfigFileFromRemoteGit = true;
    private boolean modifiedConfig;
    private boolean registerWebHooks;
    private GitRepoClient gitRepoClient;
    private KubernetesClient kubernetes;
    private String jenkinsJobUrl;
    private ProjectDTO taigaProject;
    private TaigaClient taiga;
    private String jenkinsJobName;
    private String gitSourceSecretName;
    private String jenkinsJobTemplate;
    private boolean localJenkinsFlow;

    public String toString() {
        return "DevOpsConnector{gitUrl='" + this.gitUrl + '\'' + ", basedir=" + this.basedir + ", username='" + this.username + '\'' + ", branch='" + this.branch + '\'' + ", repoName='" + this.repoName + '\'' + '}';
    }

    public void execute() throws Exception {
        LinkedHashMap environments;
        this.loadConfigFile();
        KubernetesClient kubernetes = this.getKubernetes();
        String name = this.projectName;
        if (Strings.isNullOrBlank((String)name)) {
            if (this.projectConfig != null) {
                name = this.projectConfig.getBuildName();
            }
            if (Strings.isNullOrBlank((String)name)) {
                name = this.jenkinsJob;
            }
            if (Strings.isNullOrBlank((String)name)) {
                name = ProjectRepositories.createBuildName((String)this.username, (String)this.repoName);
                if (this.projectConfig != null) {
                    this.projectConfig.setBuildName(name);
                }
            }
        }
        if (Strings.isNullOrBlank((String)this.projectName)) {
            this.projectName = name;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("user", this.username);
        labels.put("repo", this.repoName);
        this.getLog().info("build name " + name);
        this.taiga = null;
        this.taigaProject = null;
        try {
            this.taiga = this.createTaiga();
            this.taigaProject = this.createTaigaProject(this.taiga);
        }
        catch (Exception e) {
            this.getLog().error("Failed to load or lazily create the Taiga project: " + e, (Throwable)e);
        }
        this.getLog().info("taiga " + this.taiga);
        LetsChatClient letschat = null;
        try {
            letschat = this.createLetsChat();
        }
        catch (Exception e) {
            this.getLog().error("Failed to load or lazily create the LetsChat client: " + e, (Throwable)e);
        }
        this.getLog().info("letschat " + letschat);
        if (this.projectConfig != null && this.projectConfig.hasCodeReview()) {
            try {
                this.createGerritRepo(this.repoName, this.gerritUser, this.gerritPwd, this.gerritGitInitialCommit, this.gerritGitRepoDesription);
            }
            catch (Exception e) {
                this.getLog().error("Failed to create GerritGit repo : " + e, (Throwable)e);
            }
        }
        HashMap<String, String> annotations = new HashMap<String, String>();
        this.jenkinsJobUrl = null;
        String jenkinsUrl = null;
        try {
            jenkinsUrl = this.getJenkinsServiceUrl();
            if (Strings.isNotBlank((String)jenkinsUrl)) {
                String url;
                if (Strings.isNotBlank((String)this.jenkinsMonitorView)) {
                    url = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsMonitorView});
                    this.annotationLink(annotations, "fabric8.link.jenkins.monitor/", url, "Monitor");
                }
                if (Strings.isNotBlank((String)this.jenkinsPipelineView)) {
                    url = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsPipelineView});
                    this.annotationLink(annotations, "fabric8.link.jenkins.pipeline/", url, "Pipeline");
                }
                if (Strings.isNotBlank((String)name)) {
                    this.jenkinsJobUrl = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", name});
                    this.annotationLink(annotations, "fabric8.link.jenkins.job/", this.jenkinsJobUrl, "Job");
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn("Could not find the Jenkins URL!: " + e, (Throwable)e);
        }
        this.getLog().info("jenkins " + jenkinsUrl);
        if (!this.annotationLink(annotations, "fabric8.link.issues/", this.issueTrackerUrl, this.issueTrackerLabel)) {
            String taigaLink = this.getProjectPageLink(this.taiga, this.taigaProject, this.taigaProjectLinkPage);
            this.annotationLink(annotations, "fabric8.link.taiga/", taigaLink, this.taigaProjectLinkLabel);
        }
        if (!this.annotationLink(annotations, "fabric8.link.team/", this.teamUrl, this.teamLabel)) {
            String taigaTeamLink = this.getProjectPageLink(this.taiga, this.taigaProject, this.taigaTeamLinkPage);
            this.annotationLink(annotations, "fabric8.link.taiga.team/", taigaTeamLink, this.taigaTeamLinkLabel);
        }
        this.annotationLink(annotations, "fabric8.link.releases/", this.releasesUrl, this.releasesLabel);
        String chatRoomLink = this.getChatRoomLink(letschat);
        this.annotationLink(annotations, "fabric8.link.letschat.room/", chatRoomLink, this.letschatRoomLinkLabel);
        this.annotationLink(annotations, "fabric8.link.repository.browse/", this.repositoryBrowseLink, this.repositoryBrowseLabel);
        ProjectConfigs.defaultEnvironments((ProjectConfig)this.projectConfig);
        String consoleUrl = this.getServiceUrl("fabric8", this.namespace, this.fabric8ConsoleNamespace);
        if (Strings.isNotBlank((String)consoleUrl) && this.projectConfig != null && (environments = this.projectConfig.getEnvironments()) != null) {
            for (Map.Entry entry : environments.entrySet()) {
                String value;
                String label = (String)entry.getKey();
                String key = value = (String)entry.getValue();
                String environmentLink = URLUtils.pathJoin((String[])new String[]{consoleUrl, "/kubernetes/pods?namespace=" + value});
                annotations.put("fabric8.link.environment." + key + "/url", environmentLink);
                annotations.put("fabric8.link.environment." + key + "/label", label);
                this.addLink(label, environmentLink);
            }
        }
        this.addLink("Git", this.getGitUrl());
        Controller controller = this.createController();
        OpenShiftClient openShiftClient = (OpenShiftClient)this.getKubernetes().adapt(OpenShiftClient.class);
        BuildConfig buildConfig = null;
        try {
            buildConfig = (BuildConfig)((ClientBuildConfigResource)((OpenShiftClient)openShiftClient.inNamespace(this.namespace)).buildConfigs().withName(this.projectName)).get();
        }
        catch (Exception e) {
            this.log.error("Failed to load build config for " + this.namespace + "/" + this.projectName + ". " + e, (Throwable)e);
        }
        this.log.info("Loaded build config for " + this.namespace + "/" + this.projectName + " " + buildConfig);
        boolean foundExistingGitUrl = false;
        if (buildConfig != null) {
            BuildSource source;
            BuildConfigSpec spec = buildConfig.getSpec();
            if (spec != null && (source = spec.getSource()) != null) {
                LocalObjectReference sourceSecret;
                GitBuildSource git = source.getGit();
                if (git != null) {
                    this.gitUrl = git.getUri();
                    this.log.info("Loaded existing BuildConfig git url: " + this.gitUrl);
                    foundExistingGitUrl = true;
                }
                if ((sourceSecret = source.getSourceSecret()) != null) {
                    this.gitSourceSecretName = sourceSecret.getName();
                }
            }
            if (!foundExistingGitUrl) {
                this.log.warn("Could not find a git url in the loaded BuildConfig: " + buildConfig);
            }
            this.log.info("Loaded gitSourceSecretName: " + this.gitSourceSecretName);
        }
        this.log.info("gitUrl is: " + this.gitUrl);
        if (buildConfig == null) {
            buildConfig = new BuildConfig();
        }
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)buildConfig);
        metadata.setName(this.projectName);
        metadata.setAnnotations(annotations);
        metadata.setLabels(labels);
        Builds.configureDefaultBuildConfig((BuildConfig)buildConfig, (String)name, (String)this.gitUrl, (boolean)foundExistingGitUrl, (String)this.buildImageStream, (String)this.buildImageTag, (String)this.s2iCustomBuilderImage, (String)this.secret, (String)jenkinsUrl);
        try {
            this.getLog().info("About to apply build config: " + new JSONObject(KubernetesHelper.toJson((Object)buildConfig)).toString(4));
            controller.applyBuildConfig(buildConfig, "maven");
            this.getLog().info("Created build configuration for " + name + " in namespace: " + controller.getNamespace() + " at " + kubernetes.getMasterUrl());
        }
        catch (Exception e) {
            this.getLog().error("Failed to create BuildConfig for " + KubernetesHelper.toJson((Object)buildConfig) + ". " + e, (Throwable)e);
        }
        this.jenkinsJobName = name;
        if (this.isRegisterWebHooks()) {
            this.registerWebHooks();
            this.getLog().info("webhooks done");
        }
        if (this.modifiedConfig) {
            if (this.basedir == null) {
                this.getLog().error("Could not save updated fabric8.yml due to missing basedir");
            } else {
                try {
                    ProjectConfigs.saveToFolder((File)this.basedir, (ProjectConfig)this.projectConfig, (boolean)true);
                    this.getLog().info("Updated fabric8.yml");
                }
                catch (IOException e) {
                    this.getLog().error("Could not save updated fabric8.yml: " + e, (Throwable)e);
                }
            }
        }
    }

    protected String getJenkinsServiceUrl() {
        return this.getServiceUrl("jenkins", false, this.namespace, this.jenkinsNamespace);
    }

    protected String getServiceUrl(String serviceName, String ... namespaces) {
        return this.getServiceUrl(serviceName, false, namespaces);
    }

    private String getServiceUrl(String serviceName, boolean serviceExternal, String ... namespaces) {
        ArrayList<String> namespaceList = new ArrayList<String>(Arrays.asList(namespaces));
        String[] defaults = new String[]{KubernetesHelper.defaultNamespace(), "default"};
        for (String defaultNamespace : defaults) {
            if (!namespaceList.contains(defaultNamespace)) continue;
            namespaceList.add(defaultNamespace);
        }
        for (String namespace : namespaceList) {
            try {
                return KubernetesHelper.getServiceURL((KubernetesClient)this.getKubernetes(), (String)serviceName, (String)namespace, (String)"http", (boolean)serviceExternal);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected boolean annotationLink(Map<String, String> annotations, String annotationPrefix, String issueTrackerUrl, String issueTrackerLabel) {
        if (Strings.isNotBlank((String)issueTrackerUrl)) {
            annotations.put(annotationPrefix + "url", issueTrackerUrl);
            annotations.put(annotationPrefix + "label", issueTrackerLabel);
            this.addLink(issueTrackerLabel, issueTrackerUrl);
            return true;
        }
        return false;
    }

    public void registerWebHooks() {
        if (Strings.isNotBlank((String)this.jenkinsJobName)) {
            this.jenkinsJobTemplate = this.createJenkinsJob(this.jenkinsJobName, this.jenkinsJobUrl);
            this.getLog().info("created jenkins job");
        }
        if (Strings.isNotBlank((String)this.jenkinsJobUrl) && Strings.isNotBlank((String)this.jenkinsJobName)) {
            this.createJenkinsWebhook(this.jenkinsJobUrl);
        }
        if (this.taiga != null && this.taigaProject != null) {
            this.createTaigaWebhook(this.taiga, this.taigaProject);
        }
    }

    public void addLink(String label, String url) {
        if (this.projectConfig == null) {
            this.projectConfig = new ProjectConfig();
        }
        this.projectConfig.addLink(label, url);
        this.modifiedConfig = true;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public KubernetesClient getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = new DefaultKubernetesClient();
        }
        return this.kubernetes;
    }

    public GitRepoClient getGitRepoClient() {
        if (this.gitRepoClient == null) {
            this.gitRepoClient = GitRepoKubernetes.createGitRepoClient((KubernetesClient)this.getKubernetes(), (String)this.username, (String)this.password);
            if (this.gitRepoClient != null) {
                if (Strings.isNullOrBlank((String)this.username)) {
                    this.username = this.gitRepoClient.getUsername();
                }
                if (Strings.isNullOrBlank((String)this.password)) {
                    this.password = this.gitRepoClient.getPassword();
                }
            }
        }
        return this.gitRepoClient;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBuildImageStream() {
        return this.buildImageStream;
    }

    public void setBuildImageStream(String buildImageStream) {
        this.buildImageStream = buildImageStream;
    }

    public String getBuildImageTag() {
        return this.buildImageTag;
    }

    public void setBuildImageTag(String buildImageTag) {
        this.buildImageTag = buildImageTag;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setGitRepoClient(GitRepoClient gitRepoClient) {
        this.gitRepoClient = gitRepoClient;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public String getJenkinsJob() {
        return this.jenkinsJob;
    }

    public void setJenkinsJob(String jenkinsJob) {
        this.jenkinsJob = jenkinsJob;
    }

    public String getJenkinsMonitorView() {
        return this.jenkinsMonitorView;
    }

    public void setJenkinsMonitorView(String jenkinsMonitorView) {
        this.jenkinsMonitorView = jenkinsMonitorView;
    }

    public String getJenkinsPipelineView() {
        return this.jenkinsPipelineView;
    }

    public void setJenkinsPipelineView(String jenkinsPipelineView) {
        this.jenkinsPipelineView = jenkinsPipelineView;
    }

    public void setKubernetes(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public boolean isTriggerJenkinsJob() {
        return this.triggerJenkinsJob;
    }

    public void setTriggerJenkinsJob(boolean triggerJenkinsJob) {
        this.triggerJenkinsJob = triggerJenkinsJob;
    }

    public boolean isLetschatEnabled() {
        return this.letschatEnabled;
    }

    public void setLetschatEnabled(boolean letschatEnabled) {
        this.letschatEnabled = letschatEnabled;
    }

    public String getLetschatRoomExpression() {
        return this.letschatRoomExpression;
    }

    public void setLetschatRoomExpression(String letschatRoomExpression) {
        this.letschatRoomExpression = letschatRoomExpression;
    }

    public String getLetschatRoomLinkLabel() {
        return this.letschatRoomLinkLabel;
    }

    public void setLetschatRoomLinkLabel(String letschatRoomLinkLabel) {
        this.letschatRoomLinkLabel = letschatRoomLinkLabel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getFabric8ConsoleNamespace() {
        return this.fabric8ConsoleNamespace;
    }

    public void setFabric8ConsoleNamespace(String fabric8ConsoleNamespace) {
        this.fabric8ConsoleNamespace = fabric8ConsoleNamespace;
    }

    public String getJenkinsNamespace() {
        return this.jenkinsNamespace;
    }

    public void setJenkinsNamespace(String jenkinsNamespace) {
        this.jenkinsNamespace = jenkinsNamespace;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isTaigaAutoCreate() {
        return this.taigaAutoCreate;
    }

    public void setTaigaAutoCreate(boolean taigaAutoCreate) {
        this.taigaAutoCreate = taigaAutoCreate;
    }

    public boolean isTaigaEnabled() {
        return this.taigaEnabled;
    }

    public void setTaigaEnabled(boolean taigaEnabled) {
        this.taigaEnabled = taigaEnabled;
    }

    public String getTaigaProjectLinkLabel() {
        return this.taigaProjectLinkLabel;
    }

    public void setTaigaProjectLinkLabel(String taigaProjectLinkLabel) {
        this.taigaProjectLinkLabel = taigaProjectLinkLabel;
    }

    public String getTaigaProjectLinkPage() {
        return this.taigaProjectLinkPage;
    }

    public void setTaigaProjectLinkPage(String taigaProjectLinkPage) {
        this.taigaProjectLinkPage = taigaProjectLinkPage;
    }

    public String getTaigaProjectName() {
        return this.taigaProjectName;
    }

    public void setTaigaProjectName(String taigaProjectName) {
        this.taigaProjectName = taigaProjectName;
    }

    public String getTaigaProjectSlug() {
        return this.taigaProjectSlug;
    }

    public void setTaigaProjectSlug(String taigaProjectSlug) {
        this.taigaProjectSlug = taigaProjectSlug;
    }

    public String getTaigaTeamLinkLabel() {
        return this.taigaTeamLinkLabel;
    }

    public void setTaigaTeamLinkLabel(String taigaTeamLinkLabel) {
        this.taigaTeamLinkLabel = taigaTeamLinkLabel;
    }

    public String getTaigaTeamLinkPage() {
        return this.taigaTeamLinkPage;
    }

    public void setTaigaTeamLinkPage(String taigaTeamLinkPage) {
        this.taigaTeamLinkPage = taigaTeamLinkPage;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isTryLoadConfigFileFromRemoteGit() {
        return this.tryLoadConfigFileFromRemoteGit;
    }

    public void setTryLoadConfigFileFromRemoteGit(boolean tryLoadConfigFileFromRemoteGit) {
        this.tryLoadConfigFileFromRemoteGit = tryLoadConfigFileFromRemoteGit;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public void setRegisterWebHooks(boolean registerWebHooks) {
        this.registerWebHooks = registerWebHooks;
    }

    public boolean isRegisterWebHooks() {
        return this.registerWebHooks;
    }

    public String getIssueTrackerLabel() {
        return this.issueTrackerLabel;
    }

    public void setIssueTrackerLabel(String issueTrackerLabel) {
        this.issueTrackerLabel = issueTrackerLabel;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getTeamUrl() {
        return this.teamUrl;
    }

    public void setTeamUrl(String teamUrl) {
        this.teamUrl = teamUrl;
    }

    public String getTeamLabel() {
        return this.teamLabel;
    }

    public void setTeamLabel(String teamLabel) {
        this.teamLabel = teamLabel;
    }

    public String getReleasesUrl() {
        return this.releasesUrl;
    }

    public void setReleasesUrl(String releasesUrl) {
        this.releasesUrl = releasesUrl;
    }

    public String getReleasesLabel() {
        return this.releasesLabel;
    }

    public void setReleasesLabel(String releasesLabel) {
        this.releasesLabel = releasesLabel;
    }

    public String getRepositoryBrowseLabel() {
        return this.repositoryBrowseLabel;
    }

    public void setRepositoryBrowseLabel(String repositoryBrowseLabel) {
        this.repositoryBrowseLabel = repositoryBrowseLabel;
    }

    public String getRepositoryBrowseLink() {
        return this.repositoryBrowseLink;
    }

    public void setRepositoryBrowseLink(String repositoryBrowseLink) {
        this.repositoryBrowseLink = repositoryBrowseLink;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setNamespace(this.namespace);
        controller.setThrowExceptionOnError(true);
        controller.setRecreateMode(this.recreateMode);
        return controller;
    }

    protected void loadConfigFile() {
        if (this.projectConfig == null) {
            GitRepoClient gitRepo = this.getGitRepoClient();
            boolean hasLocalConfig = false;
            if (this.basedir != null && this.basedir.isDirectory()) {
                this.projectConfig = ProjectConfigs.loadFromFolder((File)this.basedir);
                if (!this.projectConfig.isEmpty() || ProjectConfigs.hasConfigFile((File)this.basedir)) {
                    hasLocalConfig = true;
                }
            }
            if (!hasLocalConfig && this.tryLoadConfigFileFromRemoteGit && Strings.isNotBlank((String)this.repoName) && gitRepo != null) {
                try {
                    InputStream input = gitRepo.getRawFile(this.username, this.repoName, this.branch, "fabric8.yml");
                    if (input != null) {
                        try {
                            this.getLog().info("Parsing fabric8.yml from the git repo " + this.repoName + " user " + this.username + " in branch " + this.branch);
                            this.projectConfig = ProjectConfigs.parseProjectConfig((InputStream)input);
                        }
                        catch (IOException e) {
                            this.getLog().warn("Failed to parse fabric8.yml from the repo " + this.repoName + " for user " + this.username + " branch: " + this.branch + ". " + e, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.getLog().warn("Failed to load fabric8.yml from the repo " + this.repoName + " for user " + this.username + " branch: " + this.branch + ". " + e, (Throwable)e);
                }
            }
        }
        if (this.projectConfig != null) {
            String issueProjectName;
            String chatRoom = this.projectConfig.getChatRoom();
            if (Strings.isNotBlank((String)chatRoom)) {
                this.getLog().info("Found chat room: " + chatRoom);
                this.letschatRoomExpression = chatRoom;
            }
            if (Strings.isNotBlank((String)(issueProjectName = this.projectConfig.getIssueProjectName()))) {
                this.taigaProjectName = issueProjectName;
            }
        } else {
            this.getLog().info("No fabric8.yml file found for " + this.basedir);
        }
        if (Strings.isNullOrBlank((String)this.gitUrl)) {
            try {
                this.gitUrl = GitHelpers.extractGitUrl((File)this.basedir);
            }
            catch (IOException e) {
                this.getLog().warn("Could not load git URL from directory: " + e, (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
            this.taigaProjectName = this.repoName;
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
            this.taigaProjectSlug = this.taigaProjectName;
        }
    }

    protected String getChatRoomLink(LetsChatClient letschat) {
        if (letschat != null) {
            try {
                String roomId;
                RoomDTO room;
                String url = letschat.getAddress();
                String slug = this.evaluateRoomExpression(this.letschatRoomExpression);
                if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && (room = letschat.getOrCreateRoom(slug)) != null && Strings.isNotBlank((String)(roomId = room.getId()))) {
                    return URLUtils.pathJoin((String[])new String[]{url, "/#!/room/" + roomId});
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to get the link to the chat room: " + e, (Throwable)e);
            }
        }
        return null;
    }

    protected String evaluateRoomExpression(String roomExpresion) {
        if (Strings.isNotBlank((String)roomExpresion)) {
            String namespace = KubernetesHelper.defaultNamespace();
            String answer = roomExpresion;
            answer = this.replaceExpression(answer, "namespace", namespace);
            answer = this.replaceExpression(answer, "repoName", this.repoName);
            answer = this.replaceExpression(answer, "username", this.username);
            return answer;
        }
        return null;
    }

    protected String replaceExpression(String text, String key, String value) {
        if (Strings.isNotBlank((String)key) && Strings.isNotBlank((String)value)) {
            String replace = "${" + key + "}";
            return text.replace(replace, value);
        }
        return text;
    }

    protected LetsChatClient createLetsChat() {
        if (!this.letschatEnabled) {
            return null;
        }
        KubernetesClient kubernetes = this.getKubernetes();
        LetsChatClient letsChat = LetsChatKubernetes.createLetsChat((KubernetesClient)kubernetes);
        if (letsChat == null) {
            this.getLog().warn("No letschat service availble n kubernetes " + this.namespace + " on address: " + kubernetes.getMasterUrl());
            return null;
        }
        if (!letsChat.isValid()) {
            this.getLog().warn("No $LETSCHAT_HUBOT_TOKEN environment variable defined so LetsChat support is disabled");
            return null;
        }
        return letsChat;
    }

    protected TaigaClient createTaiga() {
        if (!this.taigaEnabled) {
            return null;
        }
        TaigaClient taiga = TaigaKubernetes.createTaiga((KubernetesClient)this.getKubernetes(), (String)this.namespace);
        if (taiga != null) {
            taiga.setAutoCreateProjects(this.taigaAutoCreate);
        }
        return taiga;
    }

    protected String getProjectPageLink(TaigaClient taiga, ProjectDTO taigaProject, String projectRelativePage) {
        if (taiga != null && taigaProject != null) {
            try {
                String url = taiga.getAddress();
                String slug = taigaProject.getSlug();
                if (Strings.isNullOrBlank((String)slug)) {
                    slug = this.taigaProjectSlug;
                }
                String userName = taiga.getUsername();
                if (Strings.isNullOrBlank((String)slug)) {
                    slug = userName + "-" + this.taigaProjectName;
                }
                if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && Strings.isNotBlank((String)projectRelativePage)) {
                    return URLUtils.pathJoin((String[])new String[]{url, "/project/", slug + "/", projectRelativePage});
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to get project page link for " + projectRelativePage + " : " + e, (Throwable)e);
            }
        }
        return null;
    }

    protected String createJenkinsJob(String buildName, String jenkinsJobUrl) {
        String answer = null;
        if (this.projectConfig != null) {
            String template;
            String flow = this.projectConfig.getPipeline();
            String flowGitUrlValue = null;
            boolean localFlow = false;
            String projectGitUrl = this.convertGitUrlToHttpFromSsh(this.gitUrl);
            if (Strings.isNotBlank((String)flow)) {
                flowGitUrlValue = this.flowGitUrl;
            } else if (this.projectConfig.isUseLocalFlow()) {
                flow = "Jenkinsfile";
                flowGitUrlValue = projectGitUrl;
                localFlow = true;
            } else {
                this.getLog().info("Not creating Jenkins job as no pipeline defined for project configuration!");
            }
            this.localJenkinsFlow = localFlow;
            String versionPrefix = Systems.getSystemPropertyOrEnvVar((String)"VERSION_PREFIX", (String)"VERSION_PREFIX", (String)"1.0");
            if (Strings.isNotBlank((String)flow) && Strings.isNotBlank((String)projectGitUrl) && Strings.isNotBlank((String)flowGitUrlValue) && Strings.isNotBlank((String)(template = DevOpsConnector.loadJenkinsBuildTemplate(this.getLog())))) {
                if (Strings.isNotBlank((String)this.gitSourceSecretName)) {
                    template = DevOpsConnector.addBuildParameter(this.getLog(), template, "SOURCE_SECRET", this.gitSourceSecretName, "Name of the Kubernetes Secret required to clone the git repository");
                }
                template = template.replace("${FLOW_PATH}", flow);
                template = template.replace("${FLOW_GIT_URL}", flowGitUrlValue);
                template = template.replace("${GIT_URL}", projectGitUrl);
                template = template.replace("${VERSION_PREFIX}", versionPrefix);
                if (localFlow) {
                    template = DevOpsConnector.removeBuildParameter(this.getLog(), template, "GIT_URL");
                }
                this.postJenkinsBuild(buildName, template, true);
                answer = template;
            }
            this.addProjectSecret();
        }
        return answer;
    }

    private void addProjectSecret() {
    }

    protected void addJenkinsScmTrigger(String jenkinsJobUrl) {
        if (Strings.isNullOrBlank((String)this.jenkinsJobTemplate)) {
            this.getLog().warn("Cannot add SCM trigger to jenkins job at " + jenkinsJobUrl + " as there is no cached template");
        } else if (!this.localJenkinsFlow) {
            this.getLog().info("Not adding an SCM trigger to jenkins job at " + jenkinsJobUrl + " as it is not using a local Jenkinsfile");
        } else {
            this.getLog().info("Adding adding an SCM trigger to jenkins job at " + jenkinsJobUrl);
            String template = null;
            try {
                template = this.jenkinsJobTemplate;
                Document doc = DevOpsConnector.parseXmlText(template);
                Element rootElement = doc.getDocumentElement();
                Element triggerElement = null;
                NodeList triggers = rootElement.getElementsByTagName("triggers");
                triggerElement = triggers == null || triggers.getLength() == 0 ? DomHelper.addChildElement((Node)rootElement, (String)"triggers") : (Element)triggers.item(0);
                Element scmTrigger = DomHelper.addChildElement((Node)triggerElement, (String)"hudson.triggers.SCMTrigger");
                DomHelper.addChildElement((Node)scmTrigger, (String)"spec", (String)"* * * * * ");
                DomHelper.addChildElement((Node)scmTrigger, (String)"ignorePostCommitHooks", (String)"false");
                template = DomHelper.toXml((Document)doc);
            }
            catch (Exception e) {
                this.getLog().warn("Failed to add the SCM trigger to jenkins job at " + jenkinsJobUrl + ". Reason: " + e, (Throwable)e);
                template = null;
            }
            if (Strings.isNotBlank((String)template)) {
                this.postJenkinsBuild(this.jenkinsJobName, template, false);
            }
        }
    }

    protected String convertGitUrlToHttpFromSsh(String gitUrl) {
        String prefix;
        if (Strings.isNotBlank((String)gitUrl) && gitUrl.startsWith(prefix = "git@")) {
            String remaining = gitUrl.substring(prefix.length());
            remaining = remaining.replace(":", "/");
            return "https://" + remaining;
        }
        return gitUrl;
    }

    public static String loadJenkinsBuildTemplate(Logger log) {
        String template = null;
        String templateName = "jenkinsBuildConfig.xml";
        URL url = DevOpsConnector.class.getResource(templateName);
        if (url == null) {
            log.error("Could not load " + templateName + " on the classpath!");
        } else {
            try {
                template = IOHelpers.loadFully((URL)url);
            }
            catch (IOException e) {
                log.error("Failed to load template " + templateName + " from " + url + ". " + e, (Throwable)e);
            }
        }
        return template;
    }

    public static String addBuildParameter(Logger log, String template, String parameterName, String parameterValue, String description) {
        try {
            Document doc = DevOpsConnector.parseXmlText(template);
            Element rootElement = doc.getDocumentElement();
            NodeList parameterDefs = rootElement.getElementsByTagName("parameterDefinitions");
            if (parameterDefs != null && parameterDefs.getLength() > 0) {
                Node paramDefNode = parameterDefs.item(0);
                Element stringParamDef = DomHelper.addChildElement((Node)paramDefNode, (String)"hudson.model.StringParameterDefinition");
                DomHelper.addChildElement((Node)stringParamDef, (String)"name", (String)parameterName);
                DomHelper.addChildElement((Node)stringParamDef, (String)"defaultValue", (String)parameterValue);
                if (Strings.isNotBlank((String)description)) {
                    DomHelper.addChildElement((Node)stringParamDef, (String)"description", (String)description);
                }
                return DomHelper.toXml((Document)doc);
            }
            log.warn("Could not find the <parameterDefinitions> to add the build parameter name " + parameterName + " with value: " + parameterValue);
        }
        catch (Exception e) {
            log.error("Failed to add the build parameter from the Jenkins XML. " + e, (Throwable)e);
        }
        return template;
    }

    protected static Document parseXmlText(String template) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(template)));
    }

    public static String removeBuildParameter(Logger log, String template, String parameterName) {
        try {
            Document doc = DevOpsConnector.parseXmlText(template);
            Element rootElement = doc.getDocumentElement();
            NodeList stringDefs = rootElement.getElementsByTagName("hudson.model.StringParameterDefinition");
            if (stringDefs != null) {
                int size = stringDefs.getLength();
                for (int i = 0; i < size; ++i) {
                    String textContent;
                    Element element;
                    Element name;
                    Node item = stringDefs.item(i);
                    if (!(item instanceof Element) || (name = DomHelper.firstChild((Element)(element = (Element)item), (String)"name")) == null || (textContent = name.getTextContent()) == null || !parameterName.equals(textContent.trim())) continue;
                    Node parameterDefinitions = item.getParentNode();
                    Node parametersDefinitionProperty = parameterDefinitions != null ? parameterDefinitions.getParentNode() : null;
                    DomHelper.detach((Node)item);
                    if (DomHelper.firstChildElement((Node)parameterDefinitions) == null) {
                        DomHelper.detach((Node)parameterDefinitions);
                    }
                    if (DomHelper.firstChildElement((Node)parametersDefinitionProperty) == null) {
                        DomHelper.detach((Node)parametersDefinitionProperty);
                    }
                    return DomHelper.toXml((Document)doc);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to remove the build parameter from the Jenkins XML. " + e, (Throwable)e);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postJenkinsBuild(String jobName, String xml, boolean create) {
        String address = this.getServiceUrl("jenkins", false, this.namespace, this.jenkinsNamespace);
        if (Strings.isNotBlank((String)address)) {
            String jobUrl = create ? URLUtils.pathJoin((String[])new String[]{address, "/createItem"}) + "?name=" + jobName : URLUtils.pathJoin((String[])new String[]{address, "/job", jobName, "config.xml"});
            this.getLog().info("POSTING the jenkins job to: " + jobUrl);
            this.getLog().debug("Jenkins XML: " + xml);
            HttpURLConnection connection = null;
            try {
                URL url = new URL(jobUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "text/xml");
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.write(xml);
                out.close();
                int status = connection.getResponseCode();
                String message = connection.getResponseMessage();
                this.getLog().info("Got response code from Jenkins: " + status + " message: " + message);
                if (status != 200) {
                    this.getLog().error("Failed to register job " + jobName + " on " + jobUrl + ". Status: " + status + " message: " + message);
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to register jenkins on " + jobUrl + ". " + e, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    protected void createJenkinsWebhook(String jenkinsJobUrl) {
        if (Strings.isNotBlank((String)jenkinsJobUrl)) {
            boolean created;
            String jenkinsWebHook = URLUtils.pathJoin((String[])new String[]{jenkinsJobUrl, "/build"});
            Map<String, String> buildParameters = this.getBuildParameters();
            if (!buildParameters.isEmpty()) {
                String postfix = "";
                for (Map.Entry<String, String> entry : buildParameters.entrySet()) {
                    if (postfix.length() > 0) {
                        postfix = postfix + "&";
                    }
                    postfix = postfix + entry.getKey() + "=" + entry.getValue();
                }
                jenkinsWebHook = jenkinsWebHook + "WithParameters?" + postfix;
            }
            if (!(created = this.createWebhook(jenkinsWebHook, this.secret))) {
                this.addJenkinsScmTrigger(jenkinsJobUrl);
            }
            if (this.triggerJenkinsJob || !created) {
                this.triggerJenkinsWebHook(jenkinsJobUrl, jenkinsWebHook, this.secret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerJenkinsWebHook(String jobUrl, String triggerUrl, String secret) {
        String lastBuild = URLUtils.pathJoin((String[])new String[]{jobUrl, "/lastBuild/api/json"});
        JsonNode lastBuildJson = this.parseLastBuildJson(lastBuild);
        JsonNode building = null;
        if (lastBuildJson != null && lastBuildJson.isObject() && (building = lastBuildJson.get("building")) != null && building.isBoolean() && building.booleanValue()) {
            this.getLog().info("Build is already running so lets not trigger another one!");
            return;
        }
        this.getLog().info("Got last build JSON: " + lastBuildJson + " building: " + building);
        this.getLog().info("Triggering Jenkins webhook: " + triggerUrl);
        String json = "{}";
        HttpURLConnection connection = null;
        try {
            URL url = new URL(triggerUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            out.write(json);
            out.close();
            int status = connection.getResponseCode();
            String message = connection.getResponseMessage();
            this.getLog().info("Got response code from Jenkins: " + status + " message: " + message);
            if (status != 200) {
                this.getLog().error("Failed to trigger job " + triggerUrl + ". Status: " + status + " message: " + message);
            }
        }
        catch (Exception e) {
            this.getLog().error("Failed to trigger jenkins on " + triggerUrl + ". " + e, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonNode parseLastBuildJson(String urlText) {
        block7: {
            HttpURLConnection connection = null;
            String message = null;
            try {
                URL url = new URL(urlText);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                int status = connection.getResponseCode();
                message = connection.getResponseMessage();
                this.getLog().info("Got response code from URL: " + url + " " + status + " message: " + message);
                if (status != 200 || Strings.isNullOrBlank((String)message)) {
                    this.getLog().debug("Failed to load URL " + url + ". Status: " + status + " message: " + message);
                    break block7;
                }
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.reader().readTree(message);
                return jsonNode;
            }
            catch (Exception e) {
                this.getLog().debug("Failed to load URL " + urlText + ". " + e, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return null;
    }

    protected Map<String, String> getBuildParameters() {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (this.projectConfig != null) {
            Map parameters;
            String flow = this.projectConfig.getPipeline();
            if (flow != null && Strings.isNotBlank((String)this.gitUrl)) {
                answer.put("GIT_URL", this.gitUrl);
            }
            if ((parameters = this.projectConfig.getBuildParameters()) != null) {
                answer.putAll(parameters);
            }
            if (!answer.containsKey("VERSION_PREFIX")) {
                answer.put("VERSION_PREFIX", "1.0");
            }
        }
        return answer;
    }

    protected ProjectDTO createTaigaProject(TaigaClient taiga) {
        if (taiga != null) {
            if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
                this.getLog().info("Not creating Taiga project as no `fabric8.tagiaProjectName` property specified");
                return null;
            }
            if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
                this.getLog().info("Not creating Taiga project as no `fabric8.taigaProjectSlug` property specified");
                return null;
            }
            this.getLog().info("About to create Taiga project " + this.taigaProjectName + " with slug: " + this.taigaProjectSlug);
            return taiga.getOrCreateProject(this.taigaProjectName, this.taigaProjectSlug);
        }
        return null;
    }

    protected void createGerritRepo(String repoName, String gerritUser, String gerritPwd, String gerritGitInitialCommit, String gerritGitRepoDescription) throws Exception {
        if (Strings.isNullOrBlank((String)gerritUser)) {
            gerritUser = "admin";
        }
        if (Strings.isNullOrBlank((String)gerritPwd)) {
            gerritPwd = "secret";
        }
        this.log.info("A Gerrit git repo will be created for this name : " + repoName);
        String gerritAddress = KubernetesHelper.getServiceURL((KubernetesClient)this.kubernetes, (String)"gerrit", (String)this.namespace, (String)"http", (boolean)true);
        this.log.info("Found gerrit address: " + gerritAddress + " for namespace: " + this.namespace + " on Kubernetes address: " + this.kubernetes.getMasterUrl());
        if (Strings.isNullOrBlank((String)gerritAddress)) {
            throw new Exception("No address for service gerrit in namespace: " + this.namespace + " on Kubernetes address: " + this.kubernetes.getMasterUrl());
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpClient httpclientPost = HttpClients.createDefault();
        String GERRIT_URL = gerritAddress + "/a/projects/" + repoName;
        HttpGet httpget = new HttpGet(GERRIT_URL);
        System.out.println("Requesting : " + httpget.getURI());
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            System.out.println(response.getStatusLine());
            if (response.getStatusLine().getStatusCode() == 401) {
                Header authHeader = response.getFirstHeader("WWW-Authenticate");
                System.out.println("authHeader = " + authHeader);
                DigestScheme digestScheme = new DigestScheme();
                digestScheme.processChallenge(authHeader);
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(gerritUser, gerritPwd);
                httpget.addHeader(digestScheme.authenticate((Credentials)creds, (HttpRequest)httpget, null));
                HttpPost httpPost = new HttpPost(GERRIT_URL);
                httpPost.addHeader(digestScheme.authenticate((Credentials)creds, (HttpRequest)httpPost, null));
                httpPost.addHeader("Content-Type", "application/json");
                CreateRepositoryDTO createRepoDTO = new CreateRepositoryDTO();
                createRepoDTO.setDescription(gerritGitRepoDescription);
                createRepoDTO.setName(repoName);
                createRepoDTO.setCreate_empty_commit(Boolean.valueOf(gerritGitInitialCommit).booleanValue());
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString((Object)createRepoDTO);
                StringEntity entity = new StringEntity(json);
                httpPost.setEntity((HttpEntity)entity);
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = (String)httpclientPost.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                System.out.println("responseBody : " + responseBody);
            }
        }
        catch (MalformedChallengeException e) {
            e.printStackTrace();
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            System.out.println("Gerrit Server is not responding");
        }
        catch (HttpResponseException e) {
            System.out.println("Response from Gerrit Server : " + e.getMessage());
            throw new Exception("Repository " + repoName + " already exists !");
        }
        finally {
            httpclient.close();
            httpclientPost.close();
        }
    }

    protected void createTaigaWebhook(TaigaClient taiga, ProjectDTO project) {
        if (taiga != null && project != null) {
            Long projectId = project.getId();
            ModuleDTO module = taiga.moduleForProject(projectId, TaigaModule.GOGS);
            if (module != null) {
                String webhookSecret = module.getSecret();
                String webhook = taiga.getPublicWebhookUrl(module);
                if (Strings.isNotBlank((String)webhookSecret) && Strings.isNotBlank((String)webhook)) {
                    this.createWebhook(webhook, webhookSecret);
                } else {
                    this.getLog().warn("Could not create webhook for Taiga. Missing module data for url: " + webhook + " secret: " + webhookSecret);
                }
            } else {
                this.getLog().warn("No module for gogs so cannot create Taiga webhook");
            }
        }
    }

    protected boolean createWebhook(String url, String webhookSecret) {
        try {
            GitRepoClient gitRepoClient = this.getGitRepoClient();
            WebHooks.createGogsWebhook(gitRepoClient, this.getLog(), this.username, this.repoName, url, webhookSecret);
            return true;
        }
        catch (Exception e) {
            this.getLog().error("Failed to create webhook " + url + " on repository " + this.repoName + ". Reason: " + e, (Throwable)e);
            return false;
        }
    }

    @Priority(value=1000)
    protected static class RemovePrefix
    implements ReaderInterceptor {
        protected RemovePrefix() {
        }

        public Object aroundReadFrom(ReaderInterceptorContext interceptorContext) throws IOException, WebApplicationException {
            String line;
            InputStream in = interceptorContext.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder received = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                received.append(line);
            }
            String s = received.toString();
            s = s.replace(DevOpsConnector.JSON_MAGIC, "");
            System.out.println("Reader Interceptor removing the prefix invoked.");
            System.out.println("Content cleaned : " + s);
            String responseContent = new String(s);
            interceptorContext.setInputStream((InputStream)new ByteArrayInputStream(responseContent.getBytes()));
            return interceptorContext.proceed();
        }
    }
}

