/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops.connector;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.repo.git.CreateWebhookDTO;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.RepositoryDTO;
import io.fabric8.repo.git.WebHookDTO;
import io.fabric8.repo.git.WebhookConfig;
import io.fabric8.utils.Objects;
import io.fabric8.utils.cxf.JsonHelper;
import java.util.List;
import org.slf4j.Logger;

public class WebHooks {
    public static boolean createGogsWebhook(GitRepoClient repoClient, Logger log, String gogsUser, String repoName, String webhookUrl, String webhookSecret) throws JsonProcessingException {
        if (repoClient == null) {
            log.info("Cannot create Gogs webhooks as no Gogs service could be found or created");
            return false;
        }
        String gogsAddress = repoClient.getAddress();
        log.info("Querying webhooks in gogs at address: " + gogsAddress + " for user " + gogsUser + " repoName: " + repoName);
        RepositoryDTO repository = repoClient.getRepository(gogsUser, repoName);
        if (repository == null) {
            log.info("No repository found for user: " + gogsUser + " repo: " + repoName + " so cannot create any web hooks");
            return false;
        }
        List webhooks = repoClient.getWebhooks(gogsUser, repoName);
        for (WebHookDTO webhook : webhooks) {
            String url = null;
            WebhookConfig config = webhook.getConfig();
            if (config == null) continue;
            url = config.getUrl();
            if (Objects.equal((Object)webhookUrl, (Object)url)) {
                log.info("Already has webhook for: " + url + " so not creating again");
                return false;
            }
            log.info("Ignoring webhook " + url + " from: " + JsonHelper.toJson((Object)config));
        }
        CreateWebhookDTO createWebhook = new CreateWebhookDTO();
        createWebhook.setType("gogs");
        WebhookConfig config = createWebhook.getConfig();
        config.setUrl(webhookUrl);
        config.setSecret(webhookSecret);
        WebHookDTO webhook = repoClient.createWebhook(gogsUser, repoName, createWebhook);
        if (log.isDebugEnabled()) {
            log.debug("Got created web hook: " + JsonHelper.toJson((Object)webhook));
        }
        log.info("Created webhook for " + webhookUrl + " for user: " + gogsUser + " repoName: " + repoName + " on gogs URL: " + gogsAddress);
        return true;
    }
}

