/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops.connector;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.devops.connector.WebHooks;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.letschat.LetsChatClient;
import io.fabric8.letschat.LetsChatKubernetes;
import io.fabric8.letschat.RoomDTO;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.GitRepoKubernetes;
import io.fabric8.taiga.ModuleDTO;
import io.fabric8.taiga.ProjectDTO;
import io.fabric8.taiga.TaigaClient;
import io.fabric8.taiga.TaigaKubernetes;
import io.fabric8.taiga.TaigaModule;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevOpsConnector {
    private transient Logger log = LoggerFactory.getLogger(DevOpsConnector.class);
    private File basedir;
    private ProjectConfig projectConfig;
    private String username;
    private String password;
    private String branch;
    private String repoName;
    private String fullName;
    private String gitUrl;
    private String secret = "secret101";
    private String buildImageStream = "triggerJenkins";
    private String buildImageTag = "latest";
    private String jenkinsJob;
    private String jenkinsMonitorView;
    private String jenkinsPipelineView;
    private String taigaProjectName;
    private String taigaProjectSlug;
    private String taigaProjectLinkPage = "backlog";
    private String taigaProjectLinkLabel = "Backlog";
    private String taigaTeamLinkPage = "team";
    private String taigaTeamLinkLabel = "Team";
    private boolean taigaAutoCreate = true;
    private boolean taigaEnabled = true;
    private boolean letschatEnabled = true;
    private String letschatRoomLinkLabel = "Room";
    private String letschatRoomExpression = "fabric8_${namespace}";
    private GitRepoClient gitRepoClient;
    private boolean recreateMode;
    private String namespace;
    private KubernetesClient kubernetes;
    private boolean tryLoadConfigFileFromRemoteGit = true;
    private boolean modifiedConfig;

    public String toString() {
        return "DevOpsConnector{gitUrl='" + this.gitUrl + '\'' + ", basedir=" + this.basedir + ", username='" + this.username + '\'' + ", branch='" + this.branch + '\'' + ", repoName='" + this.repoName + '\'' + '}';
    }

    public void execute() throws Exception {
        String chatRoomLink;
        String taigaTeamLink;
        this.loadConfigFile();
        KubernetesClient kubernetes = this.getKubernetes();
        String name = this.repoName;
        if (Strings.isNotBlank((String)this.username)) {
            name = this.username + "-" + name;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("user", this.username);
        labels.put("repo", this.repoName);
        TaigaClient taiga = null;
        ProjectDTO taigaProject = null;
        try {
            taiga = this.createTaiga();
            taigaProject = this.createTaigaProject(taiga);
        }
        catch (Exception e) {
            this.getLog().error("Failed to load or lazily create the Taiga project: " + e, (Throwable)e);
        }
        LetsChatClient letschat = null;
        try {
            letschat = this.createLetsChat();
        }
        catch (Exception e) {
            this.getLog().error("Failed to load or lazily create the LetsChat client: " + e, (Throwable)e);
        }
        HashMap<String, String> annotations = new HashMap<String, String>();
        String jenkinsJobUrl = null;
        try {
            String jenkinsUrl = kubernetes.getServiceURL("jenkins", kubernetes.getNamespace(), "http", true);
            if (Strings.isNotBlank((String)jenkinsUrl)) {
                String label;
                String url;
                if (Strings.isNotBlank((String)this.jenkinsMonitorView)) {
                    url = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsMonitorView});
                    annotations.put("fabric8.link.jenkins.monitor/url", url);
                    label = "Monitor";
                    annotations.put("fabric8.link.jenkins.monitor/label", label);
                    this.addLink(label, url);
                }
                if (Strings.isNotBlank((String)this.jenkinsPipelineView)) {
                    url = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsPipelineView});
                    annotations.put("fabric8.link.jenkins.pipeline/url", url);
                    label = "Pipeline";
                    annotations.put("fabric8.link.jenkins.pipeline/label", label);
                    this.addLink(label, url);
                }
                if (Strings.isNotBlank((String)this.jenkinsJob)) {
                    jenkinsJobUrl = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", this.jenkinsJob});
                    annotations.put("fabric8.link.jenkins.job/url", jenkinsJobUrl);
                    String label2 = "Job";
                    annotations.put("fabric8.link.jenkins.job/label", label2);
                    this.addLink(label2, jenkinsJobUrl);
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn("Could not find the Jenkins URL!: " + e, (Throwable)e);
        }
        String taigaLink = this.getProjectPageLink(taiga, taigaProject, this.taigaProjectLinkPage);
        if (Strings.isNotBlank((String)taigaLink)) {
            annotations.put("fabric8.link.taiga/url", taigaLink);
            annotations.put("fabric8.link.taiga/label", this.taigaProjectLinkLabel);
            this.addLink(this.taigaProjectLinkLabel, taigaLink);
        }
        if (Strings.isNotBlank((String)(taigaTeamLink = this.getProjectPageLink(taiga, taigaProject, this.taigaTeamLinkPage)))) {
            annotations.put("fabric8.link.taiga.team/url", taigaTeamLink);
            annotations.put("fabric8.link.taiga.team/label", this.taigaTeamLinkLabel);
            this.addLink(this.taigaTeamLinkLabel, taigaTeamLink);
        }
        if (Strings.isNotBlank((String)(chatRoomLink = this.getChatRoomLink(letschat)))) {
            annotations.put("fabric8.link.letschat.room/url", chatRoomLink);
            annotations.put("fabric8.link.letschat.room/label", this.letschatRoomLinkLabel);
            this.addLink(this.letschatRoomLinkLabel, chatRoomLink);
        }
        BuildConfigFluent.SpecNested specBuilder = ((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(name)).withLabels(labels)).withAnnotations(annotations)).endMetadata()).withNewSpec();
        if (Strings.isNotBlank((String)this.gitUrl)) {
            specBuilder = (BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildConfigSpecFluent.SourceNested)specBuilder.withNewSource().withType("Git")).withNewGit().withUri(this.gitUrl)).endGit()).endSource();
        }
        if (Strings.isNotBlank((String)this.buildImageStream) && Strings.isNotBlank((String)this.buildImageTag)) {
            specBuilder = (BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((BuildConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Docker")).withNewDockerStrategy().withNewFrom().withName(this.buildImageStream + ":" + this.buildImageTag)).endFrom()).endDockerStrategy()).endStrategy();
        }
        BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GenericNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GithubNested)((BuildConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("github")).withNewGithub().withSecret(this.secret)).endGithub()).endTrigger()).addNewTrigger().withType("generic")).withNewGeneric().withSecret(this.secret)).endGeneric()).endTrigger()).endSpec()).build();
        Controller controller = this.createController();
        try {
            controller.applyBuildConfig(buildConfig, "maven");
            this.getLog().info("Created build configuration for " + name + " in namespace: " + controller.getNamespace() + " at " + kubernetes.getAddress());
        }
        catch (Exception e) {
            this.getLog().error("Failed to create BuildConfig for " + KubernetesHelper.toJson((Object)buildConfig) + ". " + e, (Throwable)e);
        }
        this.createJenkinsWebhook(jenkinsJobUrl);
        this.createTaigaWebhook(taiga, taigaProject);
        if (this.modifiedConfig) {
            if (this.basedir == null) {
                this.getLog().error("Could not save updated fabric8.yml due to missing basedir");
            } else {
                try {
                    ProjectConfigs.saveToFolder((File)this.basedir, (ProjectConfig)this.projectConfig, (boolean)true);
                    this.getLog().info("Updated fabric8.yml");
                }
                catch (IOException e) {
                    this.getLog().error("Could not save updated fabric8.yml: " + e, (Throwable)e);
                }
            }
        }
    }

    public void addLink(String label, String url) {
        if (this.projectConfig == null) {
            this.projectConfig = new ProjectConfig();
        }
        this.projectConfig.addLink(label, url);
        this.modifiedConfig = true;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public KubernetesClient getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = new KubernetesClient();
        }
        if (Strings.isNotBlank((String)this.namespace)) {
            this.kubernetes.setNamespace(this.namespace);
        }
        return this.kubernetes;
    }

    public GitRepoClient getGitRepoClient() {
        if (this.gitRepoClient == null) {
            this.gitRepoClient = GitRepoKubernetes.createGitRepoClient((KubernetesClient)this.getKubernetes(), (String)this.username, (String)this.password);
            if (this.gitRepoClient != null) {
                if (Strings.isNullOrBlank((String)this.username)) {
                    this.username = this.gitRepoClient.getUsername();
                }
                if (Strings.isNullOrBlank((String)this.password)) {
                    this.password = this.gitRepoClient.getPassword();
                }
            }
        }
        return this.gitRepoClient;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBuildImageStream() {
        return this.buildImageStream;
    }

    public void setBuildImageStream(String buildImageStream) {
        this.buildImageStream = buildImageStream;
    }

    public String getBuildImageTag() {
        return this.buildImageTag;
    }

    public void setBuildImageTag(String buildImageTag) {
        this.buildImageTag = buildImageTag;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setGitRepoClient(GitRepoClient gitRepoClient) {
        this.gitRepoClient = gitRepoClient;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public String getJenkinsJob() {
        return this.jenkinsJob;
    }

    public void setJenkinsJob(String jenkinsJob) {
        this.jenkinsJob = jenkinsJob;
    }

    public String getJenkinsMonitorView() {
        return this.jenkinsMonitorView;
    }

    public void setJenkinsMonitorView(String jenkinsMonitorView) {
        this.jenkinsMonitorView = jenkinsMonitorView;
    }

    public String getJenkinsPipelineView() {
        return this.jenkinsPipelineView;
    }

    public void setJenkinsPipelineView(String jenkinsPipelineView) {
        this.jenkinsPipelineView = jenkinsPipelineView;
    }

    public void setKubernetes(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public boolean isLetschatEnabled() {
        return this.letschatEnabled;
    }

    public void setLetschatEnabled(boolean letschatEnabled) {
        this.letschatEnabled = letschatEnabled;
    }

    public String getLetschatRoomExpression() {
        return this.letschatRoomExpression;
    }

    public void setLetschatRoomExpression(String letschatRoomExpression) {
        this.letschatRoomExpression = letschatRoomExpression;
    }

    public String getLetschatRoomLinkLabel() {
        return this.letschatRoomLinkLabel;
    }

    public void setLetschatRoomLinkLabel(String letschatRoomLinkLabel) {
        this.letschatRoomLinkLabel = letschatRoomLinkLabel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isTaigaAutoCreate() {
        return this.taigaAutoCreate;
    }

    public void setTaigaAutoCreate(boolean taigaAutoCreate) {
        this.taigaAutoCreate = taigaAutoCreate;
    }

    public boolean isTaigaEnabled() {
        return this.taigaEnabled;
    }

    public void setTaigaEnabled(boolean taigaEnabled) {
        this.taigaEnabled = taigaEnabled;
    }

    public String getTaigaProjectLinkLabel() {
        return this.taigaProjectLinkLabel;
    }

    public void setTaigaProjectLinkLabel(String taigaProjectLinkLabel) {
        this.taigaProjectLinkLabel = taigaProjectLinkLabel;
    }

    public String getTaigaProjectLinkPage() {
        return this.taigaProjectLinkPage;
    }

    public void setTaigaProjectLinkPage(String taigaProjectLinkPage) {
        this.taigaProjectLinkPage = taigaProjectLinkPage;
    }

    public String getTaigaProjectName() {
        return this.taigaProjectName;
    }

    public void setTaigaProjectName(String taigaProjectName) {
        this.taigaProjectName = taigaProjectName;
    }

    public String getTaigaProjectSlug() {
        return this.taigaProjectSlug;
    }

    public void setTaigaProjectSlug(String taigaProjectSlug) {
        this.taigaProjectSlug = taigaProjectSlug;
    }

    public String getTaigaTeamLinkLabel() {
        return this.taigaTeamLinkLabel;
    }

    public void setTaigaTeamLinkLabel(String taigaTeamLinkLabel) {
        this.taigaTeamLinkLabel = taigaTeamLinkLabel;
    }

    public String getTaigaTeamLinkPage() {
        return this.taigaTeamLinkPage;
    }

    public void setTaigaTeamLinkPage(String taigaTeamLinkPage) {
        this.taigaTeamLinkPage = taigaTeamLinkPage;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isTryLoadConfigFileFromRemoteGit() {
        return this.tryLoadConfigFileFromRemoteGit;
    }

    public void setTryLoadConfigFileFromRemoteGit(boolean tryLoadConfigFileFromRemoteGit) {
        this.tryLoadConfigFileFromRemoteGit = tryLoadConfigFileFromRemoteGit;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setThrowExceptionOnError(true);
        controller.setRecreateMode(this.recreateMode);
        return controller;
    }

    protected void loadConfigFile() {
        if (this.projectConfig == null) {
            GitRepoClient gitRepo = this.getGitRepoClient();
            boolean hasLocalConfig = false;
            if (this.basedir != null && this.basedir.isDirectory()) {
                this.projectConfig = ProjectConfigs.loadFromFolder((File)this.basedir);
                if (!this.projectConfig.isEmpty() || ProjectConfigs.hasConfigFile((File)this.basedir)) {
                    hasLocalConfig = true;
                }
            }
            if (!hasLocalConfig && this.tryLoadConfigFileFromRemoteGit && Strings.isNotBlank((String)this.repoName) && gitRepo != null) {
                try {
                    InputStream input = gitRepo.getRawFile(this.username, this.repoName, this.branch, "fabric8.yml");
                    if (input != null) {
                        try {
                            this.getLog().info("Parsing fabric8.yml from the git repo " + this.repoName + " user " + this.username + " in branch " + this.branch);
                            this.projectConfig = ProjectConfigs.parseProjectConfig((InputStream)input);
                        }
                        catch (IOException e) {
                            this.getLog().warn("Failed to parse fabric8.yml from the repo " + this.repoName + " for user " + this.username + " branch: " + this.branch + ". " + e, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.getLog().warn("Failed to load fabric8.yml from the repo " + this.repoName + " for user " + this.username + " branch: " + this.branch + ". " + e, (Throwable)e);
                }
            }
        }
        if (this.projectConfig != null) {
            String issueProjectName;
            String chatRoom = this.projectConfig.getChatRoom();
            if (Strings.isNotBlank((String)chatRoom)) {
                this.getLog().info("Found chat room: " + chatRoom);
                this.letschatRoomExpression = chatRoom;
            }
            if (Strings.isNotBlank((String)(issueProjectName = this.projectConfig.getIssueProjectName()))) {
                this.taigaProjectName = issueProjectName;
            }
        } else {
            this.getLog().info("No fabric8.yml file found for " + this.basedir);
        }
        if (Strings.isNullOrBlank((String)this.gitUrl)) {
            try {
                this.gitUrl = GitHelpers.extractGitUrl((File)this.basedir);
            }
            catch (IOException e) {
                this.getLog().warn("Could not load git URL from directory: " + e, (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
            this.taigaProjectName = this.repoName;
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
            this.taigaProjectSlug = this.taigaProjectName;
        }
    }

    protected String getChatRoomLink(LetsChatClient letschat) {
        if (letschat != null) {
            try {
                String roomId;
                RoomDTO room;
                String url = letschat.getAddress();
                String slug = this.evaluateRoomExpression(this.letschatRoomExpression);
                if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && (room = letschat.getOrCreateRoom(slug)) != null && Strings.isNotBlank((String)(roomId = room.getId()))) {
                    return URLUtils.pathJoin((String[])new String[]{url, "/#!/room/" + roomId});
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to get the link to the chat room: " + e, (Throwable)e);
            }
        }
        return null;
    }

    protected String evaluateRoomExpression(String roomExpresion) {
        if (Strings.isNotBlank((String)roomExpresion)) {
            String namespace = this.getKubernetes().getNamespace();
            if (namespace == null) {
                namespace = KubernetesClient.defaultNamespace();
            }
            String answer = roomExpresion;
            answer = this.replaceExpression(answer, "namespace", namespace);
            answer = this.replaceExpression(answer, "repoName", this.repoName);
            answer = this.replaceExpression(answer, "username", this.username);
            return answer;
        }
        return null;
    }

    protected String replaceExpression(String text, String key, String value) {
        if (Strings.isNotBlank((String)key) && Strings.isNotBlank((String)value)) {
            String replace = "${" + key + "}";
            return text.replace(replace, value);
        }
        return text;
    }

    protected LetsChatClient createLetsChat() {
        if (!this.letschatEnabled) {
            return null;
        }
        KubernetesClient kubernetes = this.getKubernetes();
        LetsChatClient letsChat = LetsChatKubernetes.createLetsChat((KubernetesClient)kubernetes);
        if (letsChat == null) {
            this.getLog().warn("No letschat service availble n kubernetes " + kubernetes.getNamespace() + " on address: " + kubernetes.getAddress());
            return null;
        }
        if (!letsChat.isValid()) {
            this.getLog().warn("No $LETSCHAT_HUBOT_TOKEN environment variable defined so LetsChat support is disabled");
            return null;
        }
        return letsChat;
    }

    protected TaigaClient createTaiga() {
        if (!this.taigaEnabled) {
            return null;
        }
        TaigaClient taiga = TaigaKubernetes.createTaiga((KubernetesClient)this.getKubernetes());
        if (taiga != null) {
            taiga.setAutoCreateProjects(this.taigaAutoCreate);
        }
        return taiga;
    }

    protected String getProjectPageLink(TaigaClient taiga, ProjectDTO taigaProject, String projectRelativePage) {
        if (taiga != null && taigaProject != null) {
            try {
                String url = taiga.getAddress();
                String slug = taigaProject.getSlug();
                if (Strings.isNullOrBlank((String)slug)) {
                    slug = this.taigaProjectSlug;
                }
                String userName = taiga.getUsername();
                if (Strings.isNullOrBlank((String)slug)) {
                    slug = userName + "-" + this.taigaProjectName;
                }
                if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && Strings.isNotBlank((String)projectRelativePage)) {
                    return URLUtils.pathJoin((String[])new String[]{url, "/project/", slug + "/", projectRelativePage});
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to get project page link for " + projectRelativePage + " : " + e, (Throwable)e);
            }
        }
        return null;
    }

    protected void createJenkinsWebhook(String jenkinsJobUrl) {
        if (Strings.isNotBlank((String)jenkinsJobUrl)) {
            String jenkinsWebHook = URLUtils.pathJoin((String[])new String[]{jenkinsJobUrl, "/build"});
            this.createWebhook(jenkinsWebHook, this.secret);
        }
    }

    protected ProjectDTO createTaigaProject(TaigaClient taiga) {
        if (taiga != null) {
            if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
                this.getLog().info("Not creating Taiga project as no `fabric8.tagiaProjectName` property specified");
                return null;
            }
            if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
                this.getLog().info("Not creating Taiga project as no `fabric8.taigaProjectSlug` property specified");
                return null;
            }
            this.getLog().info("About to create Taiga project " + this.taigaProjectName + " with slug: " + this.taigaProjectSlug);
            return taiga.getOrCreateProject(this.taigaProjectName, this.taigaProjectSlug);
        }
        return null;
    }

    protected void createTaigaWebhook(TaigaClient taiga, ProjectDTO project) {
        if (taiga != null && project != null) {
            Long projectId = project.getId();
            ModuleDTO module = taiga.moduleForProject(projectId, TaigaModule.GOGS);
            if (module != null) {
                String webhookSecret = module.getSecret();
                String webhook = taiga.getPublicWebhookUrl(module);
                if (Strings.isNotBlank((String)webhookSecret) && Strings.isNotBlank((String)webhook)) {
                    this.createWebhook(webhook, webhookSecret);
                } else {
                    this.getLog().warn("Could not create webhook for Taiga. Missing module data for url: " + webhook + " secret: " + webhookSecret);
                }
            } else {
                this.getLog().warn("No module for gogs so cannot create Taiga webhook");
            }
        }
    }

    protected void createWebhook(String url, String webhookSecret) {
        try {
            GitRepoClient gitRepoClient = this.getGitRepoClient();
            WebHooks.createGogsWebhook(gitRepoClient, this.getLog(), this.username, this.repoName, url, webhookSecret);
        }
        catch (Exception e) {
            this.getLog().error("Failed to create webhook " + url + " on repository " + this.repoName + ". Reason: " + e, (Throwable)e);
        }
    }
}

