/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops.connector;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.devops.ProjectRepositories;
import io.fabric8.devops.ProjectRepository;
import io.fabric8.devops.connector.DevOpsConnector;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;

public class DevOpsConnectors {
    public static DevOpsConnector createDevOpsConnector(ProjectRepository project) {
        DevOpsConnector connector = new DevOpsConnector();
        connector.setGitUrl(project.getGitUrl());
        String repoName = project.getRepoName();
        connector.setRepoName(repoName);
        String username = project.getUser();
        connector.setUsername(username);
        String buildName = ProjectRepositories.createBuildName((String)username, (String)repoName);
        if (project.isGitHubProject()) {
            ProjectConfig config;
            String url = project.getUrl();
            if (Strings.isNotBlank((String)url)) {
                connector.setIssueTrackerUrl(URLUtils.pathJoin((String[])new String[]{url, "issues"}));
                connector.setTeamUrl(URLUtils.pathJoin((String[])new String[]{url, "graphs/contributors"}));
                connector.setReleasesUrl(URLUtils.pathJoin((String[])new String[]{url, "tags"}));
                connector.setRepositoryBrowseLink(url);
            }
            if ((config = ProjectConfigs.loadFromUrl((String)URLUtils.pathJoin((String[])new String[]{url, "blob/master/fabric8.yml"}))) == null) {
                config = new ProjectConfig();
                config.setFlow("maven/Deploy.groovy");
            }
            config.setBuildName(buildName);
            connector.setProjectConfig(config);
            connector.setRegisterWebHooks(false);
            System.out.println("Created config " + config.getBuildName() + " with flow " + config.getFlow());
        }
        return connector;
    }
}

