/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.utils.Base64Encoder;
import java.security.KeyPairGenerator;
import java.util.HashMap;
import java.util.Map;

public enum SecretKeys {
    GPG_KEY("fabric8.io/secret-gpg-key"){

        @Override
        public String generate() {
            return "";
        }
    }
    ,
    SSH_KEY("fabric8.io/secret-ssh-key"){

        @Override
        public String generate() {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(512);
                byte[] publicKey = keyGen.genKeyPair().getPublic().getEncoded();
                return new String(Base64Encoder.encode((byte[])publicKey));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
    ,
    SSH_PUBLIC_KEY("fabric8.io/secret-ssh-public-key"){

        @Override
        public String generate() {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(512);
                byte[] publicKey = keyGen.genKeyPair().getPublic().getEncoded();
                return new String(Base64Encoder.encode((byte[])publicKey));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    };

    private static final Map<String, SecretKeys> map;
    private final String value;

    private SecretKeys(String value) {
        this.value = value;
    }

    public abstract String generate();

    public static boolean isSecretKey(String key) {
        return map.containsKey(key);
    }

    public static SecretKeys fromValue(String v) {
        return map.get(v);
    }

    static {
        map = new HashMap<String, SecretKeys>();
        for (SecretKeys s : SecretKeys.values()) {
            map.put(s.value, s);
        }
    }
}

