/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.concurrent.Callable;
import org.ops4j.pax.url.mvn.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLs {
    private static final transient Logger LOG = LoggerFactory.getLogger(URLs.class);

    public static <T> T doWithMavenURLHandlerFactory(Callable<T> block) throws Exception {
        URLStreamHandlerFactory factory = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.equals("mvn")) {
                    return new Handler();
                }
                return null;
            }
        };
        return URLs.doWithCustomURLHandlerFactory(factory, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithCustomURLHandlerFactory(final URLStreamHandlerFactory customFactory, Callable<T> block) throws Exception {
        final URLStreamHandlerFactory oldFactory = URLs.getURLStreamHandlerFactory();
        try {
            URLStreamHandlerFactory newFactory = new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String protocol) {
                    URLStreamHandler answer = customFactory.createURLStreamHandler(protocol);
                    if (answer == null && oldFactory != null) {
                        answer = oldFactory.createURLStreamHandler(protocol);
                    }
                    return answer;
                }
            };
            URLs.setURLStreamHandlerFactory(newFactory);
            T t = block.call();
            return t;
        }
        finally {
            URLs.setURLStreamHandlerFactory(oldFactory);
        }
    }

    static void setURLStreamHandlerFactory(URLStreamHandlerFactory newFactory) {
        String fieldName = "factory";
        Class<URL> clazz = URL.class;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            URLStreamHandlerFactory oldValue = (URLStreamHandlerFactory)field.get(null);
            if (oldValue != null) {
                field.set(null, null);
            }
        }
        catch (NoSuchFieldException e) {
            LOG.error("Could not find field " + fieldName + " in class " + clazz.getName() + ". " + e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access field " + fieldName + " in class " + clazz.getName() + ". " + e, (Throwable)e);
        }
        if (newFactory != null) {
            URL.setURLStreamHandlerFactory(newFactory);
        }
    }

    static URLStreamHandlerFactory getURLStreamHandlerFactory() {
        String fieldName = "factory";
        Class<URL> clazz = URL.class;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (URLStreamHandlerFactory)field.get(null);
        }
        catch (NoSuchFieldException e) {
            LOG.error("Could not find field " + fieldName + " in class " + clazz.getName() + ". " + e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access field " + fieldName + " in class " + clazz.getName() + ". " + e, (Throwable)e);
        }
        return null;
    }
}

