/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.enricher.EnricherUtils;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScallableResource;
import io.fabric8.kubernetes.jolokia.JolokiaClients;
import io.fabric8.utils.Strings;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jolokia.client.J4pClient;

public class J4pClientProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> clientInstance;
    @Inject
    private Instance<Session> sessionInstance;

    public boolean canProvide(Class<?> type) {
        return J4pClient.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        ReplicationController replicationController;
        Pod pod;
        Service service;
        KubernetesClient client = (KubernetesClient)this.clientInstance.get();
        Session session = (Session)this.sessionInstance.get();
        JolokiaClients jolokiaClients = new JolokiaClients(client);
        String serviceName = EnricherUtils.getServiceName(qualifiers);
        String podName = EnricherUtils.getPodName(qualifiers);
        String replicationControllerName = EnricherUtils.getReplicationControllerName(qualifiers);
        if (Strings.isNotBlank((String)serviceName) && (service = (Service)((Resource)((NonNamespaceOperation)client.services().inNamespace(session.getNamespace())).withName(serviceName)).get()) != null) {
            return jolokiaClients.clientForService(service);
        }
        if (Strings.isNotBlank((String)podName) && (pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).withName(serviceName)).get()) != null) {
            return jolokiaClients.clientForPod(pod);
        }
        if (Strings.isNotBlank((String)replicationControllerName) && (replicationController = (ReplicationController)((RollableScallableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).withName(replicationControllerName)).get()) != null) {
            return jolokiaClients.clientForReplicationController(replicationController);
        }
        return null;
    }
}

