/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.assertions.support.LogHelpers;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;

public class SessionPodsAreReady
implements Callable<Boolean> {
    private final Session session;
    private final KubernetesClient kubernetesClient;
    private File basedir;

    public SessionPodsAreReady(KubernetesClient kubernetesClient, Session session) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        List pods = Lists.notNullList((List)((PodList)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.session.getNamespace())).list()).getItems());
        if (pods.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No pods are available yet, waiting...");
        }
        for (Pod pod : pods) {
            if (KubernetesHelper.isPodReady((Pod)pod)) continue;
            PodStatus podStatus = pod.getStatus();
            int restartCount = 0;
            if (podStatus != null) {
                if ("Succeeded".equals(podStatus.getPhase())) continue;
                List containerStatuses = podStatus.getContainerStatuses();
                for (ContainerStatus containerStatus : containerStatuses) {
                    ContainerState state;
                    Integer restartCountValue;
                    if (restartCount == 0 && (restartCountValue = containerStatus.getRestartCount()) != null) {
                        restartCount = restartCountValue;
                    }
                    if ((state = containerStatus.getState()) == null) continue;
                    ContainerStateWaiting waiting = state.getWaiting();
                    String containerName = containerStatus.getName();
                    if (waiting != null) {
                        this.session.getLogger().warn("Waiting for container:" + containerName + ". Reason:" + waiting.getReason());
                        continue;
                    }
                    this.session.getLogger().warn("Waiting for container:" + containerName + ".");
                }
            }
            result = false;
            String name = KubernetesHelper.getName((HasMetadata)pod);
            File yamlFile = new File(this.session.getBaseDir(), "target/test-pod-status/" + name + ".yml");
            yamlFile.getParentFile().mkdirs();
            try {
                KubernetesHelper.saveYaml((Object)pod, (File)yamlFile);
            }
            catch (IOException e) {
                this.session.getLogger().warn("Failed to write " + yamlFile + ". " + e);
            }
            if (!KubernetesHelper.isPodRunning((Pod)pod)) continue;
            List containers = pod.getSpec().getContainers();
            for (Container container : containers) {
                File logFile = LogHelpers.getLogFileName((File)this.session.getBaseDir(), (String)name, (Container)container, (int)restartCount);
                String log = (String)((ContainerResource)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.session.getNamespace())).withName(name)).inContainer((Object)container.getName())).getLog();
                IOHelpers.writeFully((File)logFile, (String)log);
            }
        }
        return result;
    }

    private SortedMap<String, File> findLogFiles(File logDir, String name) {
        TreeMap<String, File> answer = new TreeMap<String, File>();
        File[] files = logDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!fileName.endsWith(".log") || !(fileName = Strings.stripSuffix((String)fileName, (String)".log")).startsWith(name)) continue;
                answer.put(fileName, file);
            }
        }
        return answer;
    }
}

