/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Constants;
import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.environments.Environments;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Configuration {
    private static final String NAMESPACE_PREFIX = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_NAMESPACE_PREFIX", (String)"itest-");
    private static Config FALLBACK_CONFIG = new ConfigBuilder().build();
    private KubernetesClient kubernetesClient;
    private boolean createNamespaceForTest;
    private String masterUrl;
    private List<String> environmentDependencies = new ArrayList<String>();
    private URL environmentConfigUrl;
    private String sessionId;
    private String namespace;
    private String environment;
    private boolean namespaceLazyCreateEnabled = Constants.DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED;
    private boolean namespaceCleanupEnabled = Constants.DEFAULT_NAMESPACE_CLEANUP_ENABLED;
    private long namespaceCleanupTimeout = 10000L;
    private boolean namespaceCleanupConfirmationEnabled = false;
    private long waitTimeout = Constants.DEFAULT_WAIT_TIMEOUT;
    private long waitPollInterval = Constants.DEFAULT_WAIT_POLL_INTERVAL;
    private boolean waitForServiceConnectionEnabled = Constants.DEFAULT_WAIT_FOR_SERVICE_CONNECTION_ENABLED;
    private List<String> waitForServiceList = new ArrayList<String>();
    private long waitForServiceConnectionTimeout = Constants.DEFAULT_WAIT_FOR_SERVICE_CONNECTION_TIMEOUT;
    private boolean ansiLoggerEnabled = true;
    private boolean environmentInitEnabled = true;
    private String kubernetesDomain;
    private Boolean gofabric8Enabled;
    private Map<String, String> properties;

    static void resetFallbackConfig() {
        FALLBACK_CONFIG = new ConfigBuilder().build();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Boolean getGofabric8Enabled() {
        return this.gofabric8Enabled;
    }

    public String getKubernetesDomain() {
        return this.kubernetesDomain;
    }

    public boolean isEnvironmentInitEnabled() {
        return this.environmentInitEnabled;
    }

    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    public long getWaitForServiceConnectionTimeout() {
        return this.waitForServiceConnectionTimeout;
    }

    public List<String> getWaitForServiceList() {
        return this.waitForServiceList;
    }

    public boolean isWaitForServiceConnectionEnabled() {
        return this.waitForServiceConnectionEnabled;
    }

    public long getWaitPollInterval() {
        return this.waitPollInterval;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isNamespaceCleanupConfirmationEnabled() {
        return this.namespaceCleanupConfirmationEnabled;
    }

    public long getNamespaceCleanupTimeout() {
        return this.namespaceCleanupTimeout;
    }

    public boolean isNamespaceCleanupEnabled() {
        return this.namespaceCleanupEnabled;
    }

    public boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    public boolean isCreateNamespaceForTest() {
        return this.createNamespaceForTest;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static String findNamespaceForEnvironment(String environment, Map<String, String> map, KubernetesClient kubernetesClient, String developNamespace, boolean failOnMissingEnvironmentNamespace) {
        String namespace = null;
        if (!Strings.isNullOrBlank((String)environment)) {
            LinkedHashMap environments;
            namespace = Environments.namespaceForEnvironment((KubernetesClient)kubernetesClient, (String)environment, (String)developNamespace);
            if (Strings.isNotBlank((String)namespace)) {
                return namespace;
            }
            String basedir = System.getProperty("basedir", ".");
            File folder = new File(basedir);
            ProjectConfig projectConfig = ProjectConfigs.findFromFolder((File)folder);
            if (projectConfig != null && (environments = projectConfig.getEnvironments()) != null) {
                namespace = (String)environments.get(environment);
            }
            String key = environment.toLowerCase() + ".namespace";
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = Configuration.getStringProperty(key, map, null);
            }
            if (Strings.isNullOrBlank((String)namespace)) {
                if (failOnMissingEnvironmentNamespace) {
                    throw new IllegalStateException("A fabric8 environment '" + environment + "' has been specified, but no matching namespace was found in the fabric8.yml file or '" + key + "' system property");
                }
                return developNamespace;
            }
        }
        return namespace;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public URL getEnvironmentConfigUrl() {
        return this.environmentConfigUrl;
    }

    public List<String> getEnvironmentDependencies() {
        return this.environmentDependencies;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public boolean isUseGoFabric8() {
        return this.gofabric8Enabled != null && this.gofabric8Enabled != false;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    protected static KubernetesClient getOrCreateKubernetesClient(Configuration config, KubernetesClient testKubernetesClient) {
        if (testKubernetesClient == null) {
            testKubernetesClient = !Strings.isNullOrBlank((String)config.getMasterUrl()) ? new DefaultKubernetesClient(((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(config.getMasterUrl())).withNamespace(config.getNamespace())).build()) : new DefaultKubernetesClient(((ConfigBuilder)new ConfigBuilder().withNamespace(config.getNamespace())).build());
        }
        return testKubernetesClient;
    }

    public static Configuration fromMap(Map<String, String> map, KubernetesClient testKubernetesClient) {
        Configuration configuration = new Configuration();
        try {
            KubernetesClient kubernetesClient;
            configuration.masterUrl = Configuration.getStringProperty("kubernetes.master", map, FALLBACK_CONFIG.getMasterUrl());
            configuration.environment = Configuration.getStringProperty("fabric8.environment", map, null);
            configuration.environmentInitEnabled = Configuration.getBooleanProperty("env.init.enabled", map, true);
            configuration.environmentConfigUrl = Configuration.getKubernetesConfigurationUrl(map);
            configuration.environmentDependencies = Strings.splitAndTrimAsList((String)Configuration.getStringProperty("env.dependencies", map, ""), (String)"\\s+");
            configuration.namespaceLazyCreateEnabled = Configuration.getBooleanProperty("namespace.lazy.enabled", map, Constants.DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED);
            configuration.properties = map;
            String existingNamespace = Configuration.getStringProperty("namespace.use.existing", map, null);
            configuration.sessionId = UUID.randomUUID().toString();
            configuration.namespaceCleanupConfirmationEnabled = Configuration.getBooleanProperty("namespace.cleanup.confirm.enabled", map, false);
            configuration.namespaceCleanupTimeout = Configuration.getLongProperty("namespace.cleanup.timeout", map, Constants.DEFAULT_NAMESPACE_CLEANUP_TIMEOUT);
            configuration.waitTimeout = Configuration.getLongProperty("wait.timeout", map, Constants.DEFAULT_WAIT_TIMEOUT);
            configuration.waitPollInterval = Configuration.getLongProperty("wait.poll.interval", map, Constants.DEFAULT_WAIT_POLL_INTERVAL);
            configuration.waitForServiceList = Strings.splitAndTrimAsList((String)Configuration.getStringProperty("wait.for.service.list", map, ""), (String)"\\s+");
            configuration.waitForServiceConnectionEnabled = Configuration.getBooleanProperty("wait.for.service.connection.enabled", map, Constants.DEFAULT_WAIT_FOR_SERVICE_CONNECTION_ENABLED);
            configuration.waitForServiceConnectionTimeout = Configuration.getLongProperty("wait.for.service.connection.timeout", map, Constants.DEFAULT_NAMESPACE_CLEANUP_TIMEOUT);
            configuration.ansiLoggerEnabled = Configuration.getBooleanProperty("ansi.logger.enabled", map, true);
            configuration.kubernetesDomain = Configuration.getStringProperty("kubernetes.domain", map, "");
            configuration.gofabric8Enabled = Configuration.getBooleanProperty("gofabric8.enabled", map, false);
            configuration.createNamespaceForTest = Configuration.getBooleanProperty("create.namespace.for.test", map, false);
            boolean failOnMissingEnvironmentNamespace = Configuration.getBooleanProperty("fail.on.missing.environment.namespace", map, false);
            String developNamespace = Configuration.getStringProperty("development.namespace", map, existingNamespace);
            configuration.kubernetesClient = kubernetesClient = Configuration.getOrCreateKubernetesClient(configuration, testKubernetesClient);
            String environmentNamespace = Configuration.findNamespaceForEnvironment(configuration.environment, map, kubernetesClient, developNamespace, failOnMissingEnvironmentNamespace);
            String providedNamespace = Configuration.selectNamespace(environmentNamespace, existingNamespace);
            if (configuration.createNamespaceForTest) {
                configuration.namespace = NAMESPACE_PREFIX + configuration.sessionId;
            } else {
                String namespace;
                String string = namespace = Strings.isNotBlank((String)providedNamespace) ? providedNamespace : developNamespace;
                if (Strings.isNullOrBlank((String)namespace) && Strings.isNullOrBlank((String)(namespace = kubernetesClient.getNamespace()))) {
                    namespace = KubernetesHelper.defaultNamespace();
                }
                configuration.namespace = namespace;
            }
            configuration.namespaceCleanupEnabled = Configuration.getBooleanProperty("namespace.cleanup.enabled", map, Strings.isNullOrBlank((String)providedNamespace));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        return configuration;
    }

    private static String selectNamespace(String environment, String explicit) {
        if (environment == null && explicit == null) {
            return null;
        }
        if (environment != null && explicit == null) {
            return environment;
        }
        if (environment == null && explicit != null) {
            return explicit;
        }
        if (environment.equals(explicit)) {
            return environment;
        }
        throw new IllegalStateException("Different namespace values have been specified via environment:" + environment + " and explicitly:" + explicit + ".");
    }

    private static URL getKubernetesConfigurationUrl(Map<String, String> map) throws MalformedURLException {
        if (map.containsKey("env.config.url")) {
            return new URL(map.get("env.config.url"));
        }
        if (map.containsKey("env.config.resource.name")) {
            String resourceName = map.get("env.config.resource.name");
            return Configuration.findConfigResource(resourceName);
        }
        if (Strings.isNotBlank((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""))) {
            return new URL(Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""));
        }
        String defaultValue = "/kubernetes.json";
        String resourceName = Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)defaultValue);
        URL answer = Configuration.findConfigResource(resourceName);
        if (answer == null) {
            // empty if block
        }
        return answer;
    }

    public static URL findConfigResource(String resourceName) {
        return resourceName.startsWith("/") ? Configuration.class.getResource(resourceName) : Configuration.class.getResource("/" + resourceName);
    }

    private static String getStringProperty(String name, Map<String, String> map, String defaultValue) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return Utils.getSystemPropertyOrEnvVar((String)name, (String)defaultValue);
    }

    private static Boolean getBooleanProperty(String name, Map<String, String> map, Boolean defaultValue) {
        if (map.containsKey(name)) {
            return Boolean.parseBoolean(map.get(name));
        }
        return Utils.getSystemPropertyOrEnvVar((String)name, (Boolean)defaultValue);
    }

    private static Long getLongProperty(String name, Map<String, String> map, Long defaultValue) {
        if (map.containsKey(name)) {
            return Long.parseLong(map.get(name));
        }
        return Long.parseLong(Utils.getSystemPropertyOrEnvVar((String)name, (String)String.valueOf(defaultValue)));
    }
}

