/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.utils.MultiException;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.Zips;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class Util {
    public static String readAsString(URL url) {
        StringBuilder response = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(url.openStream());
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response.toString();
    }

    public static void displaySessionStatus(KubernetesClient client, Session session) throws MultiException {
        for (ReplicationController replicationController : ((ReplicationControllerList)((NonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Replication controller:" + KubernetesHelper.getName((HasMetadata)replicationController));
        }
        for (Pod pod : ((PodList)((NonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Pod:" + KubernetesHelper.getName((HasMetadata)pod) + " Status:" + pod.getStatus());
        }
        for (Service service : ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Service:" + KubernetesHelper.getName((HasMetadata)service) + " IP:" + KubernetesHelper.getPortalIP((Service)service) + " Port:" + KubernetesHelper.getPorts((Service)service));
        }
    }

    public static void cleanupSession(KubernetesClient client, Session session) throws MultiException {
        Util.waitUntilWeCanDestroyNamespace(session);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Util.cleanupAllMatching(client, session, errors);
        try {
            ((Resource)client.namespaces().withName(session.getNamespace())).delete();
        }
        catch (Exception e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while cleaning up session.", errors);
        }
    }

    protected static void waitUntilWeCanDestroyNamespace(Session session) {
        Logger log = session.getLogger();
        String confirmDestroy = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_NAMESPACE_CONFIRM_DESTROY", (String)"false");
        if (Objects.equal((Object)confirmDestroy, (Object)"true")) {
            Util.showErrorsBeforePause(session);
            System.out.println();
            System.out.println("Waiting to destroy the namespace.");
            System.out.println("Please type: [Q] to terminate the namespace.");
            try {
                while (true) {
                    int ch;
                    if ((ch = System.in.read()) < 0 || ch == 81) {
                        System.out.println("\nStopping...");
                    }
                    System.out.println("Found character: " + Character.toString((char)ch));
                }
            }
            catch (IOException e) {
                log.warn("Failed to read from input. " + e);
            }
        } else {
            String timeoutText = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_NAMESPACE_DESTROY_TIMEOUT", (String)"0");
            Long timeout = null;
            if (Strings.isNotBlank((String)timeoutText)) {
                try {
                    timeout = Long.parseLong(timeoutText);
                }
                catch (NumberFormatException e) {
                    log.warn("Failed to parse timeout value '" + timeoutText + "' for $Constants.FABRIC8_NAMESPACE_DESTROY_TIMEOUT. " + e);
                }
            }
            if (timeout != null && timeout > 0L) {
                Util.showErrorsBeforePause(session);
                System.out.println();
                System.out.println("Sleeping for " + timeout + " seconds until destroying the namespace");
                try {
                    Thread.sleep(timeout * 1000L);
                }
                catch (InterruptedException e) {
                    log.info("Interupted sleeping to GC the namespace: " + e);
                }
            }
        }
        System.out.println("Now destroying the Fabric8 Arquillian test case namespace");
    }

    protected static void showErrorsBeforePause(Session session) {
    }

    public static void cleanupAllMatching(KubernetesClient client, Session session, List<Throwable> errors) throws MultiException {
        for (int i = 0; i < 10; ++i) {
            try {
                ((NonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.services().inNamespace(session.getNamespace())).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            List filteredPods = ((PodList)((NonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).list()).getItems();
            if (filteredPods.isEmpty()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getMavenDependencies(Session session) throws IOException {
        ArrayList<String> dependencies = new ArrayList<String>();
        try {
            File[] files;
            for (File f : files = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).importTestDependencies()).resolve()).withoutTransitivity()).asFile()) {
                if (f.getName().endsWith("jar") && Util.hasKubernetesJson(f)) {
                    Path dir = Files.createTempDirectory(session.getId(), new FileAttribute[0]);
                    try (FileInputStream fis = new FileInputStream(f);
                         JarInputStream jis = new JarInputStream(fis);){
                        Zips.unzip((InputStream)new FileInputStream(f), (File)dir.toFile());
                        File jsonPath = dir.resolve("kubernetes.json").toFile();
                        if (!jsonPath.exists()) continue;
                        dependencies.add(jsonPath.toURI().toString());
                        continue;
                    }
                }
                if (!f.getName().endsWith(".json")) continue;
                dependencies.add(f.toURI().toString());
            }
        }
        catch (Exception e) {
            session.getLogger().warn("Skipping maven project dependencies. Caused by:" + e.getMessage());
        }
        return dependencies;
    }

    private static boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals("kubernetes.json")) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }
}

