/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.annotations.ServiceName;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class ServiceResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> clientInstance;
    @Inject
    private Instance<Session> sessionInstance;

    public boolean canProvide(Class<?> type) {
        return Service.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = (KubernetesClient)this.clientInstance.get();
        Session session = (Session)this.sessionInstance.get();
        for (Service service : ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(session.getNamespace())).list()).getItems()) {
            if (!this.qualifies(service, qualifiers)) continue;
            return service;
        }
        return null;
    }

    private boolean qualifies(Service s, Annotation ... qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (!(annotation instanceof ServiceName)) continue;
            String id = ((ServiceName)annotation).value();
            return id.equals(KubernetesHelper.getName((HasMetadata)s));
        }
        return false;
    }
}

