/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.annotations.ReplicationControllerName;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class ReplicationControllerResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> clientInstance;
    @Inject
    private Instance<Session> sessionInstance;

    public boolean canProvide(Class<?> type) {
        return ReplicationController.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = (KubernetesClient)this.clientInstance.get();
        Session session = (Session)this.sessionInstance.get();
        for (ReplicationController replicationController : ((ReplicationControllerList)((NonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).list()).getItems()) {
            if (!this.qualifies(replicationController, qualifiers)) continue;
            return replicationController;
        }
        return null;
    }

    private boolean qualifies(ReplicationController r, Annotation ... qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (!(annotation instanceof ReplicationControllerName)) continue;
            String id = ((ReplicationControllerName)annotation).value();
            String rid = KubernetesHelper.getName((HasMetadata)r);
            return id.equals(rid);
        }
        return false;
    }
}

