/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.arquillian.utils.Namespaces;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.MultiException;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Util {
    public static String readAsString(URL url) {
        try {
            return IOHelpers.readFully((URL)url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void displaySessionStatus(KubernetesClient client, Session session) throws MultiException {
        for (ReplicationController replicationController : ((ReplicationControllerList)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Replication controller:" + KubernetesHelper.getName((HasMetadata)replicationController));
        }
        for (Pod pod : ((PodList)((ClientNonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Pod:" + KubernetesHelper.getName((HasMetadata)pod) + " Status:" + pod.getStatus());
        }
        for (Service service : ((ServiceList)((ClientNonNamespaceOperation)client.services().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Service:" + KubernetesHelper.getName((HasMetadata)service) + " IP:" + KubernetesHelper.getPortalIP((Service)service) + " Port:" + KubernetesHelper.getPorts((Service)service));
        }
    }

    public static void cleanupSession(KubernetesClient client, Configuration configuration, Session session, String status) throws MultiException {
        if (configuration.isNamespaceCleanupEnabled()) {
            Util.waitUntilWeCanDestroyNamespace(session);
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            Util.cleanupAllMatching(client, session, errors);
            try {
                ((ClientResource)client.namespaces().withName(session.getNamespace())).delete();
            }
            catch (Exception e) {
                errors.add(e);
            }
            if (!errors.isEmpty()) {
                throw new MultiException("Error while cleaning up session.", errors);
            }
        } else {
            Namespaces.updateNamespaceStatus(client, session, status);
        }
    }

    protected static void waitUntilWeCanDestroyNamespace(Session session) {
        Logger log = session.getLogger();
        String confirmDestroy = Systems.getEnvVarOrSystemProperty((String)"namespace.cleanup.confirm.enabled", (String)"false");
        if (Objects.equal((Object)confirmDestroy, (Object)"true")) {
            Util.showErrorsBeforePause(session);
            System.out.println();
            System.out.println("Waiting to destroy the namespace.");
            System.out.println("Please type: [Q] to terminate the namespace.");
            try {
                while (true) {
                    int ch;
                    if ((ch = System.in.read()) < 0 || ch == 81) {
                        System.out.println("\nStopping...");
                    }
                    System.out.println("Found character: " + Character.toString((char)ch));
                }
            }
            catch (IOException e) {
                log.warn("Failed to read from input. " + e);
            }
        } else {
            String timeoutText = Systems.getEnvVarOrSystemProperty((String)"namespace.cleanup.timeout", (String)"0");
            Long timeout = null;
            if (Strings.isNotBlank((String)timeoutText)) {
                try {
                    timeout = Long.parseLong(timeoutText);
                }
                catch (NumberFormatException e) {
                    log.warn("Failed to parse timeout value '" + timeoutText + "' for $Constants.NAMESPACE_CLEANUP_TIMEOUT. " + e);
                }
            }
            if (timeout != null && timeout > 0L) {
                Util.showErrorsBeforePause(session);
                System.out.println();
                System.out.println("Sleeping for " + timeout + " seconds until destroying the namespace");
                try {
                    Thread.sleep(timeout * 1000L);
                }
                catch (InterruptedException e) {
                    log.info("Interupted sleeping to GC the namespace: " + e);
                }
            }
        }
        System.out.println("Now destroying the Fabric8 Arquillian test case namespace");
    }

    protected static void showErrorsBeforePause(Session session) {
    }

    public static void cleanupAllMatching(KubernetesClient client, Session session, List<Throwable> errors) throws MultiException {
        for (int i = 0; i < 10; ++i) {
            OpenShiftClient openShiftClient = new Controller(client).getOpenShiftClientOrNull();
            String sessionNamespace = session.getNamespace();
            if (openShiftClient != null) {
                try {
                    ((ClientNonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(sessionNamespace)).delete();
                }
                catch (KubernetesClientException e) {
                    errors.add(e);
                }
                try {
                    ((ClientNonNamespaceOperation)openShiftClient.routes().inNamespace(sessionNamespace)).delete();
                }
                catch (KubernetesClientException e) {
                    errors.add(e);
                }
            }
            try {
                ((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((ClientNonNamespaceOperation)client.extensions().replicaSets().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((ClientNonNamespaceOperation)client.replicationControllers().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((ClientNonNamespaceOperation)client.pods().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((ClientNonNamespaceOperation)client.extensions().ingresses().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((ClientNonNamespaceOperation)client.services().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((ClientResource)client.securityContextConstraints().withName(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            List filteredPods = ((PodList)((ClientNonNamespaceOperation)client.pods().inNamespace(sessionNamespace)).list()).getItems();
            if (filteredPods.isEmpty()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String findGitUrl(Session session, File dir) {
        try {
            return GitHelpers.extractGitUrl((File)dir);
        }
        catch (IOException e) {
            session.getLogger().warn("Could not detect git url from directory: " + dir + ". " + e);
            return null;
        }
    }

    public static File getProjectBaseDir(Session session) {
        String basedir = System.getProperty("basedir", ".");
        return new File(basedir);
    }

    public static String getSessionStatus(Session session) {
        if (session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }
}

