/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent;

import io.fabric8.apmagent.ApmAgentMBean;
import io.fabric8.apmagent.ApmConfiguration;
import io.fabric8.apmagent.ApmConfigurationChangeListener;
import io.fabric8.apmagent.Strategy;
import io.fabric8.apmagent.metrics.ApmAgentContext;
import io.fabric8.apmagent.metrics.ThreadMetrics;
import io.fabric8.apmagent.strategy.sampling.SamplingStrategy;
import io.fabric8.apmagent.strategy.trace.TraceStrategy;
import io.fabric8.apmagent.utils.PropertyUtils;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jolokia.jvmagent.JvmAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmAgent
implements ApmAgentMBean,
ApmConfigurationChangeListener {
    public static final ApmAgent INSTANCE = new ApmAgent();
    private static final Logger LOG = LoggerFactory.getLogger(ApmAgent.class);
    final ApmConfiguration configuration = new ApmConfiguration();
    private AtomicBoolean initialized = new AtomicBoolean();
    private AtomicBoolean started = new AtomicBoolean();
    private final ApmAgentContext apmAgentContext = new ApmAgentContext(this);
    private Instrumentation instrumentation;
    private Strategy strategy;

    private ApmAgent() {
    }

    public static void agentmain(String args, Instrumentation instrumentation) throws Exception {
        try {
            ApmAgent agent = INSTANCE;
            if (agent.initialize(instrumentation, args) && agent.getConfiguration().isStartJolokiaAgent()) {
                JvmAgent.agentmain(args);
            }
        }
        catch (Exception e) {
            LOG.error("Failed in agentmain due " + e.getMessage(), e);
            throw e;
        }
    }

    public static void premain(String args, Instrumentation instrumentation) throws Exception {
        try {
            ApmAgent agent = INSTANCE;
            if (agent.initialize(instrumentation, args)) {
                if (agent.getConfiguration().isStartJolokiaAgent()) {
                    JvmAgent.premain(args);
                }
                if (agent.getConfiguration().isAutoStartMetrics()) {
                    agent.startMetrics();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed in premain due " + e.getMessage(), e);
            throw e;
        }
    }

    public static void enterMethod(String methodName) {
        if (ApmAgent.INSTANCE.started.get()) {
            ApmAgent.INSTANCE.apmAgentContext.enterMethod(Thread.currentThread(), methodName, false);
        }
    }

    public static void exitMethod(String methodName) {
        if (ApmAgent.INSTANCE.started.get()) {
            ApmAgent.INSTANCE.apmAgentContext.exitMethod(Thread.currentThread(), methodName, false);
        }
    }

    @Override
    public List<String> getTransformedMethods() {
        if (this.isInitialized()) {
            return this.apmAgentContext.getTransformedMethods();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getAllMethods() {
        if (this.isInitialized()) {
            return this.apmAgentContext.getAllMethods();
        }
        return Collections.EMPTY_LIST;
    }

    public List<ThreadMetrics> getThreadMetrics() {
        if (this.isInitialized()) {
            return this.apmAgentContext.getThreadMetrics();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public ApmConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean initialize(Instrumentation instrumentation, String args) throws Exception {
        boolean result = this.initialized.compareAndSet(false, true);
        if (result) {
            this.instrumentation = instrumentation;
            PropertyUtils.setProperties((Object)this.configuration, args);
            this.configuration.addChangeListener(this);
            this.apmAgentContext.initialize();
            ApmConfiguration.STRATEGY theStrategy = this.configuration.getStrategyImpl();
            switch (theStrategy) {
                case TRACE: {
                    this.strategy = new TraceStrategy(this.apmAgentContext, instrumentation);
                    LOG.debug("Using Trace strategy");
                    break;
                }
                default: {
                    this.strategy = new SamplingStrategy(this.apmAgentContext);
                    LOG.debug("Using Sampling strategy");
                }
            }
            this.strategy.initialize();
            Thread cleanup = new Thread(){

                @Override
                public void run() {
                    try {
                        ApmAgent apmAgent = INSTANCE;
                        apmAgent.shutDown();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to run shutdown hook due " + e.getMessage(), e);
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(cleanup);
        }
        return result;
    }

    @Override
    public void startMetrics() {
        if (this.isInitialized() && this.started.compareAndSet(false, true)) {
            this.apmAgentContext.start();
            try {
                Strategy s = this.strategy;
                if (s != null) {
                    s.start();
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to start strategy due " + e.getMessage() + ". This exception is ignored.", e);
            }
        } else {
            LOG.debug("Metrics already started");
        }
    }

    @Override
    public void stopMetrics() {
        if (this.started.compareAndSet(true, false)) {
            try {
                Strategy s = this.strategy;
                if (s != null) {
                    s.stop();
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to stop strategy due " + e.getMessage() + ". This exception is ignored.", e);
            }
            this.apmAgentContext.stop();
        }
    }

    @Override
    public void shutDown() {
        if (this.initialized.compareAndSet(true, false)) {
            this.stopMetrics();
            this.configuration.removeChangeListener(this);
            this.apmAgentContext.shutDown();
            try {
                Strategy s = this.strategy;
                if (s != null) {
                    s.shutDown();
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to shutdown due " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public void configurationChanged() {
        if (this.started.get()) {
            if (this.configuration.isMethodMetricDepthChanged()) {
                this.apmAgentContext.methodMetricsDepthChanged();
            }
            if (this.configuration.isThreadMetricDepthChanged()) {
                this.apmAgentContext.threadMetricsDepthChanged();
            }
            if (this.configuration.isStrategyChanged()) {
                boolean hasStarted = this.started.get();
                if (this.initialized.get()) {
                    this.shutDown();
                    try {
                        this.initialize(this.instrumentation, null);
                        if (hasStarted) {
                            this.startMetrics();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Could not re-initialize due " + e.getMessage() + ". This exception is ignored.", e);
                    }
                }
            }
        }
    }
}

