/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.utils;

import io.fabric8.apmagent.utils.StringArrayConverter;
import io.fabric8.apmagent.utils.TypeConversionSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PropertyUtils {
    public static boolean getProperties(Object target, Map props, String optionPrefix) {
        Method[] methods;
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("is") && !name.startsWith("get") || params.length != 0 || type == null) continue;
            try {
                String strValue;
                Object value = method.invoke(target, new Object[0]);
                if (value == null || (strValue = PropertyUtils.convertToString(value, type)) == null) continue;
                name = name.startsWith("get") ? name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4) : name.substring(2, 3).toLowerCase(Locale.ENGLISH) + name.substring(3);
                props.put(optionPrefix + name, strValue);
                rc = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rc;
    }

    public static boolean setProperties(Object target, String string) {
        boolean result = false;
        if (string != null && !string.isEmpty()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            String[] split = string.split(",");
            for (int i = 0; i < split.length; ++i) {
                String[] split2 = split[i].split("=");
                if (split2.length != 2) continue;
                String key = split2[0].trim();
                String value = split2[1].trim();
                properties.put(key, value);
            }
            result = PropertyUtils.setProperties(target, properties, "");
        }
        return result;
    }

    public static boolean setProperties(Object target, Map<String, ?> props, String optionPrefix) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator<String> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            if (!PropertyUtils.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Map<String, Object> extractProperties(Map props, String optionPrefix) {
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        HashMap<String, Object> rc = new HashMap<String, Object>(props.size());
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            iter.remove();
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!PropertyUtils.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            Class<?> clazz = target.getClass();
            Method setter = PropertyUtils.findSetterMethod(clazz, name);
            if (setter == null) {
                return false;
            }
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, PropertyUtils.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Object convert(Object value, Class to) {
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(to)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (to.isAssignableFrom(value.getClass())) {
            return to.cast(value);
        }
        if (to.isAssignableFrom(String[].class)) {
            return StringArrayConverter.convertToStringArray(value);
        }
        TypeConversionSupport.Converter converter = TypeConversionSupport.lookupConverter(value.getClass(), to);
        if (converter != null) {
            return converter.convert(value);
        }
        throw new IllegalArgumentException("Cannot convert from " + value.getClass() + " to " + to + " with value " + value);
    }

    public static String convertToString(Object value, Class to) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (String[].class.isInstance(value)) {
            String[] array = (String[])value;
            return StringArrayConverter.convertToString(array);
        }
        TypeConversionSupport.Converter converter = TypeConversionSupport.lookupConverter(value.getClass(), String.class);
        if (converter != null) {
            return (String)converter.convert(value);
        }
        throw new IllegalArgumentException("Cannot convert from " + value.getClass() + " to " + to + " with value " + value);
    }

    private static Method findSetterMethod(Class clazz, String name) {
        Method[] methods;
        name = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            return method;
        }
        return null;
    }

    public static String toString(Object target) {
        return PropertyUtils.toString(target, Object.class, null);
    }

    public static String toString(Object target, Class stopClass) {
        return PropertyUtils.toString(target, stopClass, null);
    }

    public static String toString(Object target, Class stopClass, Map<String, Object> overrideFields) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        PropertyUtils.addFields(target, target.getClass(), stopClass, map);
        if (overrideFields != null) {
            for (String key : overrideFields.keySet()) {
                Object value = overrideFields.get(key);
                map.put(key, value);
            }
        }
        StringBuffer buffer = new StringBuffer(PropertyUtils.simpleName(target.getClass()));
        buffer.append(" {");
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        boolean first = true;
        for (Map.Entry<String, Object> entry : entrySet) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append((Object)key);
            buffer.append(" = ");
            buffer.append(value);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String simpleName(Class clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static void addFields(Object target, Class startClass, Class<Object> stopClass, LinkedHashMap<String, Object> map) {
        Field[] fields;
        if (startClass != stopClass) {
            PropertyUtils.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        for (Field field : fields = startClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

