/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.strategy.trace;

import io.fabric8.apmagent.ApmConfiguration;
import io.fabric8.apmagent.ClassInfo;
import io.fabric8.apmagent.Strategy;
import io.fabric8.apmagent.metrics.ApmAgentContext;
import io.fabric8.apmagent.strategy.trace.ApmClassVisitor;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceStrategy
implements Strategy,
ClassFileTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(TraceStrategy.class);
    private ApmAgentContext context;
    private ApmConfiguration configuration;
    private Instrumentation instrumentation;
    private BlockingQueue<Class<?>> blockingQueue = new LinkedBlockingDeque();
    private AtomicBoolean initialized = new AtomicBoolean();
    private AtomicBoolean started = new AtomicBoolean();
    private AtomicBoolean cleanUp = new AtomicBoolean();
    private Thread transformThread;

    public TraceStrategy(ApmAgentContext context, Instrumentation instrumentation) {
        this.context = context;
        this.configuration = context.getConfiguration();
        this.instrumentation = instrumentation;
    }

    @Override
    public void initialize() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            this.configuration.addChangeListener(this);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.initialize();
            this.instrumentApplication();
        }
    }

    @Override
    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            // empty if block
        }
    }

    @Override
    public void shutDown() {
        if (this.initialized.compareAndSet(true, false)) {
            this.stop();
            this.configuration.removeChangeListener(this);
            this.instrumentation.removeTransformer(this);
            Thread t = this.transformThread;
            this.transformThread = null;
            if (t != null && !t.isInterrupted()) {
                t.interrupt();
            }
            this.cleanUp.set(true);
            try {
                this.instrumentApplication();
            }
            catch (Throwable e) {
                LOG.warn("Failed to shutdown due " + e.getMessage() + ". This exception is ignored.", e);
            }
        }
    }

    public boolean isAudit(String className) {
        return this.configuration.isAudit(className);
    }

    public boolean isAudit(String className, String methodName) {
        return this.configuration.isAudit(className, methodName);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] buffer = null;
        ClassInfo classInfo = this.context.getClassInfo(className);
        classInfo.setOriginalClass(classBeingRedefined);
        if (classInfo.getTransformed() == null) {
            classInfo.setOriginal(classfileBuffer);
        }
        if (!this.cleanUp.get()) {
            byte[] classBufferToRedefine = classInfo.getOriginal();
            if (this.configuration.isAudit(className)) {
                if (classInfo.isTransformed()) {
                    this.context.resetMethods(classInfo);
                }
                ClassReader cr = new ClassReader(classBufferToRedefine);
                ClassWriter cw = new ClassWriter(cr, 3);
                ApmClassVisitor visitor = new ApmClassVisitor(this, cw, classInfo);
                cr.accept(visitor, 4);
                buffer = cw.toByteArray();
                if (!this.verifyClass(className, buffer)) {
                    classInfo.setCanTransform(false);
                    buffer = null;
                }
                classInfo.setTransformed(buffer);
            }
        } else if (classInfo.getOriginal() != null) {
            buffer = classInfo.getOriginal();
            this.context.resetAll(classInfo);
        }
        return buffer;
    }

    @Override
    public void configurationChanged() {
        List<ClassInfo> deltas;
        if (this.started.get() && this.configuration.isFilterChanged() && (deltas = this.context.buildDeltaList()) != null && !deltas.isEmpty()) {
            for (ClassInfo classInfo : deltas) {
                if (this.configuration.isAsyncTransformation()) {
                    try {
                        this.blockingQueue.put(classInfo.getOriginalClass());
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                try {
                    this.instrumentation.retransformClasses(classInfo.getOriginalClass());
                }
                catch (Throwable e) {
                    LOG.warn("Could not transform " + classInfo.getClassName() + " due " + e.getMessage(), e);
                }
            }
            if (this.configuration.isAsyncTransformation() && !this.blockingQueue.isEmpty()) {
                this.startTransformThread();
            }
        }
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void setInstrumentation(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public ApmAgentContext getContext() {
        return this.context;
    }

    public void setContext(ApmAgentContext context) {
        this.context = context;
        this.configuration = context.getConfiguration();
    }

    private void instrumentApplication() throws FileNotFoundException, UnmodifiableClassException {
        if (!this.instrumentation.isRetransformClassesSupported()) {
            throw new UnmodifiableClassException();
        }
        this.instrumentation.addTransformer(this, true);
        for (Class c : this.instrumentation.getAllLoadedClasses()) {
            if (!this.isInstrumentClass(c)) continue;
            if (this.configuration.isAsyncTransformation()) {
                try {
                    this.blockingQueue.put(c);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                this.instrumentation.retransformClasses(c);
            }
            catch (Throwable e) {
                LOG.error("Could not transform " + c.getName(), e);
            }
        }
        if (this.configuration.isAsyncTransformation() && !this.blockingQueue.isEmpty()) {
            this.startTransformThread();
        }
    }

    private boolean isInstrumentClass(Class c) {
        if (!this.instrumentation.isModifiableClass(c)) {
            LOG.trace("NO INSTRUMENT: Class {} is not modifiable", (Object)c.getName());
            return false;
        }
        if (!this.configuration.isAudit(c.getName())) {
            LOG.trace("NO INSTRUMENT: Class {} is blacklisted", (Object)c.getName());
            return false;
        }
        if (c.isArray() || c.isAnnotation() || c.isInterface() || c.isPrimitive() || c.isSynthetic() || c.isEnum()) {
            LOG.trace("NO INSTRUMENT: Class {} is an array, primitive, annotation or enum etc.", (Object)c.getName());
            return false;
        }
        return true;
    }

    private synchronized void startTransformThread() {
        if (this.configuration.isAsyncTransformation() && this.transformThread == null) {
            this.transformThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (TraceStrategy.this.initialized.get() && !TraceStrategy.this.blockingQueue.isEmpty()) {
                        try {
                            Class aClass = (Class)TraceStrategy.this.blockingQueue.take();
                            if (aClass == null || !TraceStrategy.this.isInstrumentClass(aClass)) continue;
                            try {
                                TraceStrategy.this.instrumentation.retransformClasses(aClass);
                            }
                            catch (Throwable e) {
                                LOG.error("Could not transform " + aClass.getName(), e);
                            }
                        }
                        catch (InterruptedException e) {
                            TraceStrategy.this.shutDown();
                        }
                    }
                }
            });
            this.transformThread.setDaemon(true);
            this.transformThread.start();
        }
    }

    private boolean verifyClass(String className, byte[] transformed) {
        boolean result = true;
        if (this.configuration.isVerifyClasses()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            CheckClassAdapter.verify(new ClassReader(transformed), false, pw);
            if (sw.toString().length() != 0) {
                result = false;
                LOG.error("Failed to transform class: " + className);
                LOG.error(sw.toString());
            }
        }
        return result;
    }
}

