/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent;

import io.fabric8.apmagent.ApmConfigurationChangeListener;
import io.fabric8.apmagent.ApmConfigurationMBean;
import io.fabric8.apmagent.FilterItem;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmConfiguration
implements ApmConfigurationMBean {
    static final Logger logger = LoggerFactory.getLogger(ApmConfiguration.class);
    private boolean trace = false;
    private boolean debug = false;
    private boolean asyncTransformation = false;
    private boolean startJolokiaAgent = false;
    private boolean autoStartMetrics = false;
    private boolean usePlatformMBeanServer = true;
    private boolean verifyClasses = false;
    private int methodMetricDepth = 10;
    private int threadMetricDepth = 5;
    private boolean filterChanged = false;
    private boolean methodMetricDepthChanged = false;
    private boolean threadMetricDepthChanged = false;
    private boolean strategyChanged = false;
    private int samplingInterval = 1;
    private List<FilterItem> whiteFilterList = new ArrayList<FilterItem>();
    private List<FilterItem> blackFilterList = new ArrayList<FilterItem>();
    private List<ApmConfigurationChangeListener> changeListeners = new CopyOnWriteArrayList<ApmConfigurationChangeListener>();
    private STRATEGY strategy = STRATEGY.TRACE;

    ApmConfiguration() {
        this.addToBlackList("java");
        this.addToBlackList("com.sun");
        this.addToBlackList("sun");
        this.addToBlackList("$Proxy");
        this.addToBlackList("ByCGLIB$$");
        this.addToBlackList("io.fabric8.apmagent");
        this.addToBlackList("org.apache.camel.spring.remoting");
        this.addToBlackList("org.jolokia");
        this.addToBlackList("org.springframework");
        this.addToBlackList("org.eclipse");
        this.addToBlackList("org.apache.xbean");
        this.addToBlackList("org.slf4j");
        this.addToBlackList("org.omg");
        this.addToBlackList("com.apple");
        this.addToBlackList("oracle");
        this.addToBlackList("org.apache.log4j");
        this.addToBlackList("org.objectweb.asm");
        this.addToBlackList("org.apache.commons");
        this.addToBlackList("org.apache.jasper");
        this.addToBlackList("jrockit");
        this.addToBlackList("org.json");
        this.addToBlackList("org.fusesource.hawtbuf");
        this.addToBlackList("com.intellij");
        this.addToBlackList("org.w3c.dom");
        this.addToBlackList("com.codahale");
        this.addToWhiteList("io.fabric8.testApp");
    }

    @Override
    public String getWhiteList() {
        return this.getListAsString(this.whiteFilterList);
    }

    @Override
    public void setWhiteList(String whiteList) {
        this.whiteFilterList = new ArrayList<FilterItem>();
        this.initializeList(whiteList, this.whiteFilterList);
        this.filterChanged = true;
        this.fireConfigurationChanged();
    }

    @Override
    public String getBlackList() {
        return this.getListAsString(this.blackFilterList);
    }

    @Override
    public void setBlackList(String blackList) {
        this.blackFilterList = new ArrayList<FilterItem>();
        this.initializeList(blackList, this.blackFilterList);
        this.filterChanged = true;
        this.fireConfigurationChanged();
    }

    @Override
    public void addToBlackList(String s) {
        FilterItem filterItem = new FilterItem();
        String[] classAndMethod = s.split("@");
        filterItem.setClassName(classAndMethod[0]);
        if (classAndMethod.length > 1) {
            filterItem.setMethodName(classAndMethod[1]);
        }
        this.blackFilterList.add(filterItem);
        this.filterChanged = true;
        this.fireConfigurationChanged();
    }

    @Override
    public void addToWhiteList(String s) {
        FilterItem filterItem = new FilterItem();
        String[] classAndMethod = s.split("@");
        filterItem.setClassName(classAndMethod[0]);
        if (classAndMethod.length > 1) {
            filterItem.setMethodName(classAndMethod[1]);
        }
        this.whiteFilterList.add(filterItem);
        this.filterChanged = true;
        this.fireConfigurationChanged();
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    @Override
    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isAsyncTransformation() {
        return this.asyncTransformation;
    }

    @Override
    public void setAsyncTransformation(boolean asyncTransformation) {
        this.asyncTransformation = asyncTransformation;
    }

    public boolean isStartJolokiaAgent() {
        return this.startJolokiaAgent;
    }

    public void setStartJolokiaAgent(boolean startJolokiaAgent) {
        this.startJolokiaAgent = startJolokiaAgent;
    }

    public boolean isAutoStartMetrics() {
        return this.autoStartMetrics;
    }

    public void setAutoStartMetrics(boolean autoStartMetrics) {
        this.autoStartMetrics = autoStartMetrics;
    }

    public boolean isUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public void setUsePlatformMBeanServer(boolean usePlatformMBeanServer) {
        this.usePlatformMBeanServer = usePlatformMBeanServer;
    }

    public boolean isVerifyClasses() {
        return this.verifyClasses;
    }

    public void setVerifyClasses(boolean verifyClasses) {
        this.verifyClasses = verifyClasses;
    }

    @Override
    public int getThreadMetricDepth() {
        return this.threadMetricDepth;
    }

    @Override
    public void setThreadMetricDepth(int threadMetricDepth) {
        this.threadMetricDepth = threadMetricDepth;
        this.threadMetricDepthChanged = true;
        this.fireConfigurationChanged();
    }

    @Override
    public int getMethodMetricDepth() {
        return this.methodMetricDepth;
    }

    @Override
    public void setMethodMetricDepth(int methodMetricDepth) {
        this.methodMetricDepth = methodMetricDepth;
        this.methodMetricDepthChanged = true;
        this.fireConfigurationChanged();
    }

    public boolean isStrategyChanged() {
        return this.strategyChanged;
    }

    public boolean isThreadMetricDepthChanged() {
        return this.threadMetricDepthChanged;
    }

    public boolean isMethodMetricDepthChanged() {
        return this.methodMetricDepthChanged;
    }

    public boolean isFilterChanged() {
        return this.filterChanged;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingInterval(int samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    @Override
    public String getStrategy() {
        return this.strategy.name();
    }

    @Override
    public void setStrategy(String name) {
        STRATEGY newStrategy = STRATEGY.getStrategy(name);
        if (!this.strategy.equals((Object)newStrategy)) {
            this.strategy = STRATEGY.getStrategy(name);
            this.strategyChanged = true;
            this.fireConfigurationChanged();
        }
    }

    public STRATEGY getStrategyImpl() {
        return this.strategy;
    }

    public void initalizeFromProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public boolean isAudit(String className) {
        return this.isWhiteListed(className) || !this.isBlackListed(className);
    }

    public boolean isAudit(String className, String methodName) {
        return this.isWhiteListed(className, methodName) || !this.isBlackListed(className, methodName);
    }

    public boolean isBlackListed(String className) {
        for (FilterItem item : this.blackFilterList) {
            if (!item.matches(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlackListed(String className, String methodName) {
        for (FilterItem item : this.blackFilterList) {
            if (!item.matches(className, methodName, true)) continue;
            return true;
        }
        return false;
    }

    public boolean isWhiteListed(String className) {
        if (this.whiteFilterList.isEmpty()) {
            return false;
        }
        for (FilterItem item : this.whiteFilterList) {
            if (!className.matches(item.getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean isWhiteListed(String className, String methodName) {
        for (FilterItem item : this.whiteFilterList) {
            if (!item.matches(className, methodName, false)) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ApmConfigurationChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ApmConfigurationChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireConfigurationChanged() {
        for (ApmConfigurationChangeListener apmConfigurationChangeListener : this.changeListeners) {
            apmConfigurationChangeListener.configurationChanged();
        }
        this.resetChanged();
    }

    private void resetChanged() {
        this.filterChanged = false;
        this.methodMetricDepthChanged = false;
        this.threadMetricDepthChanged = false;
        this.strategyChanged = false;
    }

    private void setProperty(String name, Object value) {
        try {
            Method setter = this.findSetterMethod(name);
            if (setter != null) {
                if (value == null || value.getClass().equals(setter.getParameterTypes()[0])) {
                    setter.invoke((Object)this, value);
                } else {
                    setter.invoke((Object)this, this.convert(value, setter.getParameterTypes()[0]));
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to set property: " + e.getMessage(), e);
        }
    }

    private Method findSetterMethod(String name) {
        Method[] methods;
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method method : methods = ApmConfiguration.class.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(methodName) || params.length != 1) continue;
            return method;
        }
        return null;
    }

    private Object convert(Object value, Class type) throws Exception {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }

    private void initializeList(String str, List<FilterItem> list) {
        String[] split;
        for (String s : split = str.split(",")) {
            FilterItem filterItem = new FilterItem();
            String[] classAndMethod = s.split("@");
            filterItem.setClassName(classAndMethod[0]);
            if (classAndMethod.length > 1) {
                filterItem.setMethodName(classAndMethod[1]);
            }
            list.add(filterItem);
        }
    }

    private String getListAsString(List<FilterItem> list) {
        String result = "";
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                FilterItem filterItem = list.get(i);
                result = result + filterItem.getClassName();
                String methodName = filterItem.getMethodName();
                if (methodName != null && methodName.length() > 0) {
                    result = result + "@" + methodName;
                }
                if (i >= list.size() - 1) continue;
                result = result + ",";
            }
        }
        return result;
    }

    public static enum STRATEGY {
        TRACE,
        SAMPLE;


        static STRATEGY getStrategy(String name) {
            for (STRATEGY v : STRATEGY.values()) {
                if (!v.name().equals(name.toUpperCase())) continue;
                return v;
            }
            return SAMPLE;
        }
    }
}

