/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.x500.X500Principal;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.jvmagent.handler.JolokiaHttpHandler;
import org.jolokia.util.LogHandler;

public class JolokiaHttpsHandler
extends JolokiaHttpHandler {
    private static final String CLIENTAUTH_OID = "1.3.6.1.5.5.7.3.2";
    private final boolean useClientCertAuth;
    private final List<LdapName> allowedPrincipals;
    private final boolean extendedClientCheck;

    public JolokiaHttpsHandler(JolokiaServerConfig pConfig) {
        this(pConfig, null);
    }

    public JolokiaHttpsHandler(JolokiaServerConfig pConfig, LogHandler pLogHandler) {
        super(pConfig.getJolokiaConfig(), pLogHandler);
        this.useClientCertAuth = pConfig.useSslClientAuthentication();
        this.allowedPrincipals = this.parseAllowedPrincipals(pConfig);
        this.extendedClientCheck = pConfig.getExtendedClientCheck();
    }

    @Override
    protected void checkAuthentication(HttpExchange pHttpExchange) throws SecurityException {
        HttpsExchange httpsExchange = (HttpsExchange)pHttpExchange;
        if (this.useClientCertAuth) {
            this.checkCertForClientUsage(httpsExchange);
            this.checkCertForAllowedPrincipals(httpsExchange);
        }
    }

    private void checkCertForClientUsage(HttpsExchange pHttpsExchange) {
        try {
            Certificate[] peerCerts = pHttpsExchange.getSSLSession().getPeerCertificates();
            if (peerCerts != null && peerCerts.length > 0) {
                X509Certificate clientCert = (X509Certificate)peerCerts[0];
                if (this.extendedClientCheck && (clientCert.getExtendedKeyUsage() == null || !clientCert.getExtendedKeyUsage().contains(CLIENTAUTH_OID))) {
                    throw new SecurityException("No extended key usage available");
                }
            }
        }
        catch (ClassCastException e) {
            throw new SecurityException("No X509 client certificate");
        }
        catch (CertificateParsingException e) {
            throw new SecurityException("Can't parse client cert");
        }
        catch (SSLPeerUnverifiedException e) {
            throw new SecurityException("SSL Peer couldn't be verified");
        }
    }

    private void checkCertForAllowedPrincipals(HttpsExchange pHttpsExchange) {
        if (this.allowedPrincipals != null) {
            try {
                X500Principal certPrincipal = (X500Principal)pHttpsExchange.getSSLSession().getPeerPrincipal();
                Set<Rdn> certPrincipalRdns = this.getPrincipalRdns(certPrincipal);
                for (LdapName principal : this.allowedPrincipals) {
                    for (Rdn rdn : principal.getRdns()) {
                        if (certPrincipalRdns.contains(rdn)) continue;
                        throw new SecurityException("Principal " + certPrincipal + " not allowed");
                    }
                }
            }
            catch (SSLPeerUnverifiedException e) {
                throw new SecurityException("SSLPeer unverified");
            }
            catch (ClassCastException e) {
                throw new SecurityException("Internal: Invalid Principal class provided " + e);
            }
        }
    }

    private Set<Rdn> getPrincipalRdns(X500Principal principal) {
        try {
            LdapName certAsLdapName = new LdapName(principal.getName());
            return new HashSet<Rdn>(certAsLdapName.getRdns());
        }
        catch (InvalidNameException e) {
            throw new SecurityException("Cannot parse '" + principal + "' as LDAP name");
        }
    }

    private List<LdapName> parseAllowedPrincipals(JolokiaServerConfig pConfig) {
        List<String> principals = pConfig.getClientPrincipals();
        if (principals != null) {
            ArrayList<LdapName> ret = new ArrayList<LdapName>();
            for (String principal : principals) {
                try {
                    ret.add(new LdapName(principal));
                }
                catch (InvalidNameException e) {
                    throw new IllegalArgumentException("Principal '" + principal + "' cannot be parsed as X500 RDNs");
                }
            }
            return ret;
        }
        return null;
    }
}

