/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands;

import io.fabric8.api.BootstrapComplete;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.CreateAction;
import io.fabric8.boot.commands.service.CreateAvailable;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ResolverCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.osgi.framework.BundleContext;

@Command(name="create", scope="fabric", description="Creates a new fabric ensemble (ZooKeeper ensemble) and imports fabric profiles", detailedDescription="classpath:create.txt")
@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class, CreateAvailable.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"create"})})
public class CreateCommand
extends AbstractCommandComponent
implements CreateAvailable {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "create";
    public static final String DESCRIPTION = "Creates a new fabric ensemble (ZooKeeper ensemble) and imports fabric profiles";
    @Reference
    private BootstrapComplete bootComplete;
    @Reference(referenceInterface=ZooKeeperClusterBootstrap.class, bind="bindBootstrap", unbind="unbindBootstrap")
    private final ValidatingReference<ZooKeeperClusterBootstrap> bootstrap = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ResolverCompleter.class, bind="bindResolverCompleter", unbind="unbindResolverCompleter")
    private ResolverCompleter resolverCompleter;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new CreateAction(this.bundleContext, (ZooKeeperClusterBootstrap)this.bootstrap.get(), (RuntimeProperties)this.runtimeProperties.get());
    }

    void bindBootstrap(ZooKeeperClusterBootstrap bootstrap) {
        this.bootstrap.bind((Object)bootstrap);
    }

    void unbindBootstrap(ZooKeeperClusterBootstrap bootstrap) {
        this.bootstrap.unbind((Object)bootstrap);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindResolverCompleter(ResolverCompleter completer) {
        this.bindOptionalCompleter(completer);
    }

    void unbindResolverCompleter(ResolverCompleter completer) {
        this.unbindOptionalCompleter(completer);
    }

    protected void bindBootComplete(BootstrapComplete bootstrapComplete) {
        this.bootComplete = bootstrapComplete;
    }

    protected void unbindBootComplete(BootstrapComplete bootstrapComplete) {
        if (this.bootComplete == bootstrapComplete) {
            this.bootComplete = null;
        }
    }
}

