/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public final class FabricValidations {
    private static final Pattern ALLOWED_NAMES_PATTERN = Pattern.compile("[a-zA-Z0-9]+[\\.a-zA-Z0-9_-]*");

    private FabricValidations() {
    }

    public static void validateProfileNames(Collection<String> profileNames) {
        if (profileNames != null && !profileNames.isEmpty()) {
            for (String profileName : profileNames) {
                FabricValidations.validateProfileName(profileName);
            }
        }
    }

    public static void validateProfileName(String profileName) {
        if (!FabricValidations.isValidName(profileName)) {
            throw new IllegalArgumentException("Profile name '" + profileName + "' is invalid");
        }
    }

    public static void validateContainerNames(List<String> containerNames) {
        if (containerNames != null && !containerNames.isEmpty()) {
            for (String containerName : containerNames) {
                FabricValidations.validateContainerName(containerName);
            }
        }
    }

    public static void validateContainerName(String containerName) {
        if (!FabricValidations.isValidName(containerName)) {
            throw new IllegalArgumentException("Container name '" + containerName + "' is invalid");
        }
    }

    public static boolean isValidName(String containerName) {
        return containerName != null && !containerName.isEmpty() && ALLOWED_NAMES_PATTERN.matcher(containerName).matches();
    }
}

