/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Systems {
    private static final transient Logger LOG = LoggerFactory.getLogger(Systems.class);

    public static String getEnvVarOrSystemProperty(String envVarName, String systemProperty, String defaultValue) {
        String answer = null;
        try {
            answer = System.getenv(envVarName);
        }
        catch (Exception e) {
            LOG.warn("Failed to look up environment variable $" + envVarName + ". " + e, (Throwable)e);
        }
        if (Strings.isNullOrBlank(answer)) {
            answer = System.getProperty(systemProperty, defaultValue);
        }
        if (Strings.isNotBlank(answer)) {
            return answer;
        }
        return defaultValue;
    }

    public static String getEnvVar(String envVarName, String defaultValue) {
        String envVar = null;
        try {
            envVar = System.getenv(envVarName);
        }
        catch (Exception e) {
            LOG.warn("Failed to look up environment variable $" + envVarName + ". " + e, (Throwable)e);
        }
        if (Strings.isNotBlank(envVar)) {
            return envVar;
        }
        return defaultValue;
    }
}

