/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.FabricService;
import io.fabric8.common.util.Strings;
import io.fabric8.core.jmx.Links;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.core.UriInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(ResourceSupport.class);
    private ResourceSupport parent;
    @Resource
    private MessageContext messageContext;
    private FabricService fabricService;
    private CuratorFramework curator;
    private String baseUri;

    public ResourceSupport() {
    }

    public ResourceSupport(ResourceSupport parent) {
        this(parent, "");
    }

    public ResourceSupport(ResourceSupport parent, String pathPrefix) {
        this.parent = parent;
        this.messageContext = parent.messageContext;
        this.fabricService = parent.getFabricService();
        this.curator = parent.getCurator();
        this.baseUri = parent.getBaseUri();
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        if (Strings.notEmpty((String)pathPrefix)) {
            this.baseUri = this.baseUri + pathPrefix;
        }
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    protected String getLink(String path) {
        String baseUri = this.getBaseUri();
        return Links.getLink((String)path, (String)baseUri);
    }

    public ResourceSupport getParent() {
        return this.parent;
    }

    protected String getParentBaseUri() {
        if (this.parent != null) {
            return this.parent.getBaseUri();
        }
        return "";
    }

    protected String getBaseUri() {
        if (this.baseUri == null) {
            URI baseUriObject;
            UriInfo uriInfo;
            if (this.messageContext != null && (uriInfo = this.messageContext.getUriInfo()) != null && (baseUriObject = uriInfo.getBaseUri()) != null) {
                this.baseUri = baseUriObject.toString();
            }
            if (this.baseUri == null) {
                this.baseUri = "";
            }
        }
        return this.baseUri;
    }

    protected Map<String, String> mapToLinks(Iterable<String> keys, String path) {
        return Links.mapIdsToLinks(keys, (String)(this.getBaseUri() + path));
    }

    protected void noFabricService() {
        LOG.warn("No FabricService available!");
    }
}

