/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jmx.FabricStatusDTO;
import io.fabric8.common.util.Strings;
import io.fabric8.rest.ContainerResource;
import io.fabric8.rest.FabricDTO;
import io.fabric8.rest.RegistryResource;
import io.fabric8.rest.ResourceSupport;
import io.fabric8.rest.VersionResource;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json"})
public class FabricResource
extends ResourceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FabricResource.class);

    @GET
    public FabricDTO details() {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null) {
            return new FabricDTO(fabricService, this.getLink("/containers"), this.getLink("/versions"), this.getLink("/status"), this.getLink("/requirements"), this.getLink("/registry"), this.getLink("/zookeeper"));
        }
        this.noFabricService();
        return null;
    }

    @GET
    @Path(value="containers")
    public Map<String, String> containers() {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null) {
            return this.mapToLinks(Containers.containerIds((Container[])fabricService.getContainers()), "/container/");
        }
        this.noFabricService();
        return Collections.EMPTY_MAP;
    }

    @Path(value="container/{containerId}")
    public ContainerResource container(@PathParam(value="containerId") String containerId) {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null && Strings.isNotBlank((String)containerId)) {
            Container container = fabricService.getContainer(containerId);
            if (container != null) {
                return new ContainerResource((ResourceSupport)this, container);
            }
            LOG.warn("No container found for: {}", (Object)container);
        }
        return null;
    }

    @GET
    @Path(value="versions")
    public Map<String, String> versions() {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null) {
            List versionIds = Profiles.versionIds((Version[])fabricService.getVersions());
            return this.mapToLinks(versionIds, "/version/");
        }
        this.noFabricService();
        return Collections.EMPTY_MAP;
    }

    @Path(value="version/{versionId}")
    public VersionResource version(@PathParam(value="versionId") String versionId) {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null && Strings.isNotBlank((String)versionId)) {
            Version version = fabricService.getVersion(versionId);
            if (version != null) {
                return new VersionResource(this, version);
            }
            LOG.warn("No version found for: {}", (Object)version);
        }
        return null;
    }

    @GET
    @Path(value="status")
    public FabricStatusDTO status() {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null) {
            return new FabricStatusDTO(fabricService.getFabricStatus());
        }
        return null;
    }

    @GET
    @Path(value="requirements")
    public FabricRequirements requirements() {
        return this.getFabricService().getRequirements();
    }

    @POST
    @Path(value="requirements")
    public void setRequirements(FabricRequirements requirements) throws IOException {
        FabricService service = this.getFabricService();
        service.setRequirements(requirements);
    }

    @Path(value="registry")
    public RegistryResource registry() {
        return new RegistryResource(this, "/registry/", "/fabric/registry/");
    }

    @Path(value="zookeeper")
    public RegistryResource zookeeper() {
        return new RegistryResource(this, "/zookeeper/", "/");
    }
}

