/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerMetadata;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profiles;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.common.util.Objects;
import io.fabric8.container.process.JavaContainerConfig;
import io.fabric8.container.process.JolokiaAgentHelper;
import io.fabric8.container.process.ProcessContainerConfig;
import io.fabric8.container.process.ProcessControllerFactoryService;
import io.fabric8.deployer.JavaContainers;
import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.service.child.ChildContainerController;
import io.fabric8.service.child.ChildContainers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManagerController
implements ChildContainerController {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessManagerController.class);
    private final ProcessControllerFactoryService owner;
    private final Configurer configurer;
    private final ProcessManager processManager;
    private final FabricService fabricService;
    private final ExecutorService downloadExecutor = Executors.newSingleThreadExecutor();

    public ProcessManagerController(ProcessControllerFactoryService owner, Configurer configurer, ProcessManager processManager, FabricService fabricService) {
        this.owner = owner;
        this.configurer = configurer;
        this.processManager = processManager;
        this.fabricService = fabricService;
    }

    public CreateChildContainerMetadata create(CreateChildContainerOptions options, CreationStateListener listener) throws Exception {
        String jolokiaUrl;
        CreateChildContainerMetadata metadata = new CreateChildContainerMetadata();
        String containerId = options.getName();
        metadata.setCreateOptions((CreateContainerOptions)options);
        metadata.setContainerName(containerId);
        Container container = null;
        try {
            container = this.fabricService.getContainer(containerId);
        }
        catch (Exception e) {
            LOG.debug("Could nto find container: " + containerId);
        }
        Map environmentVariables = ChildContainers.getEnvironmentVariables((FabricService)this.fabricService, (CreateContainerBasicOptions)options);
        Installation installation = null;
        InstallOptions parameters = null;
        try {
            if (ChildContainers.isJavaContainer((FabricService)this.fabricService, (CreateContainerBasicOptions)options)) {
                parameters = this.createJavaInstallOptions(container, metadata, options, environmentVariables);
                Objects.notNull((Object)parameters, (String)"JavaInstall parameters");
                installation = this.processManager.installJar(parameters);
            } else {
                parameters = this.createProcessInstallOptions(container, metadata, options, environmentVariables);
                InstallTask postInstall = this.createProcessPostInstall(options);
                Objects.notNull((Object)parameters, (String)"process parameters");
                installation = this.processManager.install(parameters, postInstall);
            }
        }
        catch (Exception e) {
            this.handleException("Creating container " + containerId, e);
        }
        LOG.info("Creating process container with environment vars: " + environmentVariables);
        String defaultHost = this.fabricService.getCurrentContainer().getLocalHostname();
        if (Strings.isNullOrBlank((String)defaultHost)) {
            defaultHost = "localhost";
        }
        if (!Strings.isNullOrBlank((String)(jolokiaUrl = JolokiaAgentHelper.findJolokiaUrlFromEnvironmentVariables(environmentVariables, defaultHost)))) {
            JavaContainers.registerJolokiaUrl((Container)container, (String)jolokiaUrl);
        }
        if (installation != null) {
            installation.getController().start();
        }
        return metadata;
    }

    public void start(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().start();
            }
            catch (Exception e) {
                this.handleException("Starting container " + container.getId(), e);
            }
        }
    }

    public void stop(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().stop();
            }
            catch (Exception e) {
                this.handleException("Stopping container " + container.getId(), e);
            }
        }
    }

    public void destroy(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().stop();
            }
            catch (Exception e) {
                LOG.info("Failed to stop process for container " + container.getId() + ". " + e, (Throwable)e);
            }
            installation.getController().uninstall();
        }
    }

    protected InstallOptions createJavaInstallOptions(Container container, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, Map<String, String> environmentVariables) throws Exception {
        String name2;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map javaContainerConfig = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.container.java");
        JavaContainerConfig javaConfig = new JavaContainerConfig();
        this.configurer.configure(javaContainerConfig, (Object)javaConfig);
        boolean isJavaContainer = true;
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
        if (JolokiaAgentHelper.hasJolokiaAgent(environmentVariables)) {
            int jolokiaPort = this.owner.createJolokiaPort(container.getId());
            JolokiaAgentHelper.substituteEnvironmentVariables(javaConfig, environmentVariables, isJavaContainer, JolokiaAgentHelper.getJolokiaPortOverride(jolokiaPort), JolokiaAgentHelper.getJolokiaAgentIdOverride(this.fabricService.getEnvironment()));
        } else {
            JolokiaAgentHelper.substituteEnvironmentVariables(javaConfig, environmentVariables, isJavaContainer, JolokiaAgentHelper.getJolokiaAgentIdOverride(this.fabricService.getEnvironment()));
        }
        List profiles = Profiles.getProfiles((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId);
        Map javaArtifacts = JavaContainers.getJavaContainerArtifactsFiles((FabricService)this.fabricService, (List)profiles, (ExecutorService)this.downloadExecutor);
        if (container != null) {
            ArrayList<String> provisionList = new ArrayList<String>();
            for (String name2 : javaArtifacts.keySet()) {
                int idx = name2.indexOf(":mvn:");
                if (idx > 0) {
                    name2 = name2.substring(idx + 1);
                }
                provisionList.add(name2);
            }
            Collections.sort(provisionList);
            container.setProvisionList(provisionList);
        }
        InstallOptions.InstallOptionsBuilder builder = InstallOptions.builder();
        builder.jarFiles(javaArtifacts.values());
        builder.id(options.getName());
        builder.environment(environmentVariables);
        String mainClass = environmentVariables.get("FABRIC8_JAVA_MAIN");
        name2 = "java";
        if (!Strings.isNullOrBlank((String)mainClass)) {
            name2 = name2 + " " + mainClass;
        }
        builder.name(name2);
        metadata.setContainerType(name2);
        builder.mainClass(mainClass);
        return builder.build();
    }

    protected InstallOptions createProcessInstallOptions(Container container, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, Map<String, String> environmentVariables) throws Exception {
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map configuration = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.container.process");
        ProcessContainerConfig configObject = new ProcessContainerConfig();
        this.configurer.configure(configuration, (Object)configObject);
        return configObject.createProcessInstallOptions(this.fabricService, metadata, options, environmentVariables);
    }

    protected InstallTask createProcessPostInstall(CreateChildContainerOptions options) {
        return null;
    }

    protected Installation getInstallation(Container container) {
        return this.processManager.getInstallation(container.getId());
    }

    protected void handleException(String message, Exception cause) {
        throw new RuntimeException(message + ". " + cause, cause);
    }
}

