/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Objects;
import io.fabric8.container.process.JolokiaAgentHelper;
import io.fabric8.container.process.ProcessManagerController;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.service.child.ChildContainerController;
import io.fabric8.service.child.ChildContainers;
import io.fabric8.service.child.ProcessControllerFactory;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.process.controller", label="Fabric8 Child Process Container Controller", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ProcessControllerFactory.class})
public class ProcessControllerFactoryService
extends AbstractComponent
implements ProcessControllerFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessControllerFactoryService.class);
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ProcessManager.class)
    private final ValidatingReference<ProcessManager> processManager = new ValidatingReference();
    @Property(name="monitorPollTime", longValue={1500L}, label="Monitor poll period", description="The number of milliseconds after which the processes will be polled to check they are started and still alive.")
    private long monitorPollTime = 1500L;
    private int externalPortCounter;
    private Timer keepAliveTimer;

    @Activate
    void activate() {
        this.activateComponent();
        this.keepAliveTimer = new Timer("fabric8-process-container-monitor");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ProcessControllerFactoryService.this.checkProcessesStatus();
            }
        };
        this.keepAliveTimer.schedule(timerTask, this.monitorPollTime, this.monitorPollTime);
    }

    @Deactivate
    void deactivate() {
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
            this.keepAliveTimer = null;
        }
        this.deactivateComponent();
    }

    public ChildContainerController createController(CreateChildContainerOptions options) {
        boolean isJavaContainer = ChildContainers.isJavaContainer((FabricService)this.getFabricService(), (CreateContainerBasicOptions)options);
        boolean isProcessContainer = ChildContainers.isProcessContainer((FabricService)this.getFabricService(), (CreateContainerBasicOptions)options);
        if (isProcessContainer || isJavaContainer) {
            return this.createProcessManagerController();
        }
        return null;
    }

    public ChildContainerController getControllerForContainer(Container container) {
        Installation installation = this.getProcessManager().getInstallation(container.getId());
        ProcessManagerController answer = null;
        if (installation != null) {
            answer = this.createProcessManagerController();
        }
        return answer;
    }

    public synchronized int createJolokiaPort(String containerId) {
        FabricService fabricService = this.getFabricService();
        Container currentContainer = fabricService.getCurrentContainer();
        Set usedPortByHost = fabricService.getPortService().findUsedPortByHost(currentContainer);
        do {
            if (this.externalPortCounter <= 0) {
                this.externalPortCounter = 8778;
                continue;
            }
            ++this.externalPortCounter;
        } while (usedPortByHost.contains(this.externalPortCounter));
        Container container = fabricService.getCurrentContainer();
        String pid = "io.fabric8.jolokia";
        String key = containerId;
        fabricService.getPortService().registerPort(container, pid, key, this.externalPortCounter);
        return this.externalPortCounter;
    }

    protected ProcessManagerController createProcessManagerController() {
        return new ProcessManagerController(this, this.configurer, this.getProcessManager(), this.getFabricService());
    }

    protected ProcessManager getProcessManager() {
        return (ProcessManager)this.processManager.get();
    }

    FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    void unbindConfigurer(Configurer configurer) {
        this.configurer = null;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindProcessManager(ProcessManager processManager) {
        this.processManager.bind((Object)processManager);
    }

    void unbindProcessManager(ProcessManager processManager) {
        this.processManager.unbind((Object)processManager);
    }

    protected void checkProcessesStatus() {
        ProcessManager manager = this.getProcessManager();
        FabricService fabric = this.getFabricService();
        if (manager != null && fabric != null) {
            ImmutableMap map = manager.listInstallationMap();
            ImmutableSet entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String id = (String)entry.getKey();
                Installation installation = (Installation)entry.getValue();
                try {
                    Container container = null;
                    try {
                        container = fabric.getContainer(id);
                    }
                    catch (Exception e) {
                        LOG.debug("No container for id: " + id + ". " + e, (Throwable)e);
                    }
                    if (container == null) continue;
                    Long pid = installation.getActivePid();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Polling container " + id + " for its PID");
                    }
                    if (pid == null) {
                        if (!container.isAlive()) continue;
                        container.setAlive(false);
                        continue;
                    }
                    if (pid == null || pid == 0L) continue;
                    if (!container.isAlive()) {
                        container.setAlive(true);
                    }
                    if (!Objects.equal((Object)container.getProvisionResult(), (Object)"success")) {
                        container.setProvisionResult("success");
                    }
                    JolokiaAgentHelper.jolokiaKeepAliveCheck(fabric, container);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get PID for process " + id + ". " + e, (Throwable)e);
                }
            }
        }
    }
}

