/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import io.fabric8.api.CreateChildContainerMetadata;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.common.util.Objects;
import io.fabric8.process.manager.InstallOptions;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;

@Component(name="io.fabric8.container.process", label="Fabric8 Process Child Container Configuration", immediate=false, metatype=true)
public class ProcessContainerConfig {
    @Property(label="Process name", description="The descriptive name to refer to this process when listing the processes on this machine.")
    private String processName;
    @Property(label="Distribution URL", cardinality=1, description="The URL (usually using maven coordinates) for the distribution to download and unpack.")
    private String url;
    @Property(name="controllerPath", label="Controller JSON Path", value={"controller.json"}, description="The name of the JSON file in the Profile which is used to control the distribution; starting and stopping the process.")
    private String controllerPath = "controller.json";

    public InstallOptions createProcessInstallOptions(FabricService fabricService, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, Map<String, String> environmentVariables) throws MalformedURLException {
        Profile profile;
        byte[] jsonData = null;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        List profiles = Profiles.getProfiles((FabricService)fabricService, (Iterable)profileIds, (String)versionId);
        Iterator i$ = profiles.iterator();
        while (i$.hasNext() && (jsonData = (profile = (Profile)i$.next()).getFileConfiguration(this.controllerPath)) == null) {
        }
        Objects.notNull((Object)jsonData, (String)("No JSON file found for path " + this.controllerPath + " in profiles: " + profileIds + " version: " + versionId));
        String controllerJson = new String(jsonData);
        String installName = this.getProcessName();
        if (Strings.isNullOrBlank((String)installName) && profiles.size() > 0) {
            installName = ((Profile)profiles.get(0)).getId();
        }
        metadata.setContainerType(installName);
        return InstallOptions.builder().id(options.getName()).name(installName).url(this.url).controllerJson(controllerJson).environment(environmentVariables).build();
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getControllerPath() {
        return this.controllerPath;
    }

    public void setControllerPath(String controllerPath) {
        this.controllerPath = controllerPath;
    }
}

