/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.container.process.JavaContainerConfig;
import io.fabric8.deployer.JavaContainers;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaAgentHelper {
    public static final int DEFAULT_JOLOKIA_PORT = 8778;
    public static final String JOLOKIA_PORTS_PID = "io.fabric8.jolokia";
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaAgentHelper.class);
    private static ObjectMapper jolokiaMapper = new ObjectMapper();

    public static String findJolokiaUrlFromEnvironmentVariables(Map<String, String> environmentVariables, String defaultHost) {
        String javaAgent = JolokiaAgentHelper.getJavaAgent(environmentVariables);
        return JolokiaAgentHelper.findJolokiaUrlFromJavaAgent(javaAgent, defaultHost);
    }

    public static String getJavaAgent(Map<String, String> environmentVariables) {
        return environmentVariables.get("FABRIC8_JAVA_AGENT");
    }

    public static boolean hasJolokiaAgent(String javaAgent) {
        return Strings.isNotBlank((String)javaAgent) && javaAgent.contains("jolokia");
    }

    public static boolean hasJolokiaAgent(Map<String, String> environmentVariables) {
        String javaAgent = JolokiaAgentHelper.getJavaAgent(environmentVariables);
        return JolokiaAgentHelper.hasJolokiaAgent(javaAgent);
    }

    public static String findJolokiaUrlFromJavaAgent(String javaAgent, String defaultHost) {
        if (JolokiaAgentHelper.hasJolokiaAgent(javaAgent)) {
            String[] valueExpressions;
            Properties properties = new Properties();
            String propertyText = javaAgent.trim();
            while (propertyText.endsWith("\"") || propertyText.endsWith("'")) {
                propertyText = propertyText.substring(0, propertyText.length() - 1);
            }
            int start = javaAgent.indexOf(61);
            if (start >= 0 && (valueExpressions = (propertyText = propertyText.substring(start + 1)).split(",")) != null) {
                for (String expression : valueExpressions) {
                    String[] keyValue = expression.split("=");
                    if (keyValue == null || keyValue.length <= 1) continue;
                    properties.put(keyValue[0], keyValue[1]);
                }
            }
            String port = properties.getProperty("port", "8778");
            String host = properties.getProperty("host", "0.0.0.0");
            if (host.equals("0.0.0.0")) {
                host = defaultHost;
            }
            return "http://" + host + ":" + port + "/jolokia/";
        }
        return null;
    }

    public static EnvironmentVariableOverride getJolokiaPortOverride(final int jolokiaPort) {
        return new EnvironmentVariableOverride(){

            @Override
            public String getKey() {
                return "FABRIC8_JOLOKIA_PROXY_PORT";
            }

            @Override
            public String getValue(String originalValue) {
                return "" + jolokiaPort;
            }
        };
    }

    public static EnvironmentVariableOverride getJolokiaAgentIdOverride(final String prefix) {
        return new EnvironmentVariableOverride(){

            @Override
            public String getKey() {
                return "FABRIC8_KARAF_NAME";
            }

            @Override
            public String getValue(String originalValue) {
                if (Strings.isNullOrBlank((String)prefix)) {
                    return originalValue;
                }
                return prefix + "--" + originalValue;
            }
        };
    }

    public static void substituteEnvironmentVariables(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, EnvironmentVariableOverride ... overrides) {
        UpdateAction action = JolokiaAgentHelper.substituteEnvironmentVariablesOnly(environmentVariables, overrides);
        JolokiaAgentHelper.updateJavaAgent(javaConfig, environmentVariables, isJavaContainer, action);
        JolokiaAgentHelper.updateArguments(javaConfig, environmentVariables, isJavaContainer, action);
        JolokiaAgentHelper.updateJvmArguments(javaConfig, environmentVariables, isJavaContainer, action);
    }

    public static UpdateAction substituteEnvironmentVariablesOnly(final Map<String, String> environmentVariables, EnvironmentVariableOverride[] overrides) {
        final Map<String, EnvironmentVariableOverride> overridesMap = JolokiaAgentHelper.getStringEnvironmentVariableOverrideMap(overrides);
        final HashMap used = new HashMap();
        return new UpdateAction(){

            @Override
            public String go(String string) {
                String answer = string;
                for (String key : environmentVariables.keySet()) {
                    String value = (String)environmentVariables.get(key);
                    if (overridesMap.containsKey(key)) {
                        EnvironmentVariableOverride override = (EnvironmentVariableOverride)overridesMap.remove(key);
                        value = override.getValue(value);
                        used.put(key, override);
                    }
                    answer = answer.replace("${env:" + key + "}", value);
                }
                for (String key : overridesMap.keySet()) {
                    answer = answer.replace("${env:" + key + "}", ((EnvironmentVariableOverride)overridesMap.get(key)).getValue(null));
                }
                for (String key : used.keySet()) {
                    overridesMap.put(key, used.get(key));
                }
                return answer;
            }
        };
    }

    private static Map<String, EnvironmentVariableOverride> getStringEnvironmentVariableOverrideMap(EnvironmentVariableOverride ... overrides) {
        HashMap<String, EnvironmentVariableOverride> overridesMap = new HashMap<String, EnvironmentVariableOverride>();
        for (EnvironmentVariableOverride override : overrides) {
            overridesMap.put(override.getKey(), override);
        }
        return overridesMap;
    }

    private static void updateArguments(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, UpdateAction action) {
        String arguments = javaConfig.getArguments();
        if (Strings.isNotBlank((String)arguments)) {
            arguments = action.go(arguments);
        }
        javaConfig.setArguments(arguments);
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
    }

    private static void updateJvmArguments(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, UpdateAction action) {
        String jvmArguments = javaConfig.getJvmArguments();
        if (Strings.isNotBlank((String)jvmArguments)) {
            jvmArguments = action.go(jvmArguments);
        }
        javaConfig.setJvmArguments(jvmArguments);
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
    }

    private static void updateJavaAgent(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, UpdateAction action) {
        String javaAgent = javaConfig.getJavaAgent();
        if (Strings.isNotBlank((String)javaAgent)) {
            javaAgent = action.go(javaAgent);
        }
        javaConfig.setJavaAgent(javaAgent);
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
    }

    public static void jolokiaKeepAliveCheck(FabricService fabric, String jolokiaUrl, String containerName) {
        Container container = null;
        try {
            container = fabric.getContainer(containerName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (container != null) {
            if (!Objects.equal((Object)jolokiaUrl, (Object)container.getJolokiaUrl())) {
                container.setJolokiaUrl(jolokiaUrl);
            }
            JolokiaAgentHelper.jolokiaKeepAliveCheck(fabric, container);
        }
    }

    public static void jolokiaKeepAliveCheck(FabricService fabric, Container container) {
        String jolokiaUrl = container.getJolokiaUrl();
        if (Strings.isNullOrBlank((String)jolokiaUrl)) {
            return;
        }
        String containerName = container.getId();
        boolean debugLog = LOG.isDebugEnabled();
        if (debugLog) {
            LOG.debug("Performing keep alive jolokia check on " + containerName + " URL: " + jolokiaUrl);
        }
        String user = fabric.getZooKeeperUser();
        String password = fabric.getZookeeperPassword();
        String url = jolokiaUrl;
        int idx = jolokiaUrl.indexOf("://");
        if (idx > 0) {
            url = "http://" + user + ":" + password + "@" + jolokiaUrl.substring(idx + 3);
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + "list/?maxDepth=1";
        ArrayList jmxDomains = new ArrayList();
        boolean valid = false;
        try {
            JsonNode value;
            URL theUrl = new URL(url);
            JsonNode jsonNode = jolokiaMapper.readTree(theUrl);
            if (jsonNode != null && (value = jsonNode.get("value")) != null) {
                Iterator iter = value.getFieldNames();
                while (iter.hasNext()) {
                    jmxDomains.add(iter.next());
                }
                if (debugLog) {
                    LOG.debug("Container " + containerName + " has JMX Domains: " + jmxDomains);
                }
                valid = jmxDomains.size() > 0;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to query: " + url + ". " + e, (Throwable)e);
        }
        String provisionResult = container.getProvisionResult();
        if (debugLog) {
            LOG.debug("Current provision result: " + provisionResult + " valid: " + valid);
        }
        if (valid) {
            if (!Objects.equal((Object)"success", (Object)provisionResult) || !container.isAlive()) {
                container.setProvisionResult("success");
                container.setProvisionException(null);
                container.setAlive(true);
                JavaContainers.registerJolokiaUrl((Container)container, (String)jolokiaUrl);
            }
            if (!Objects.equal(jmxDomains, (Object)container.getJmxDomains())) {
                container.setJmxDomains(jmxDomains);
            }
        } else {
            if (container.isAlive()) {
                container.setAlive(true);
            }
            if (!Objects.equal((Object)"failed", (Object)provisionResult)) {
                container.setProvisionResult("failed");
            }
        }
    }

    public static interface UpdateAction {
        public String go(String var1);
    }

    public static interface EnvironmentVariableOverride {
        public String getKey();

        public String getValue(String var1);
    }
}

