/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import io.fabric8.partition.WorkItem;
import io.fabric8.partition.WorkItemListener;
import io.fabric8.partition.WorkItemRepository;
import io.fabric8.partition.internal.WorkItemImpl;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseWorkItemRepository
implements WorkItemRepository {
    final List<WorkItemListener> workItemListeners = new CopyOnWriteArrayList<WorkItemListener>();
    final ObjectMapper mapper = new ObjectMapper();
    final TypeReference<HashMap<String, String>> partitionTypeRef = new TypeReference<HashMap<String, String>>(){};

    public abstract String readContent(String var1);

    @Override
    public void notifyListeners() {
        for (WorkItemListener workItemListener : this.workItemListeners) {
            workItemListener.partitionUpdated();
        }
    }

    @Override
    public void addListener(WorkItemListener workItemListener) {
        this.workItemListeners.add(workItemListener);
    }

    @Override
    public void removeListener(WorkItemListener workItemListener) {
        this.workItemListeners.remove(workItemListener);
    }

    @Override
    public WorkItem readWorkItem(String location) {
        String id = location.contains(File.separator) ? location.substring(location.lastIndexOf(File.separator) + 1) : location;
        try {
            String content = this.readContent(location);
            Map data = (Map)this.mapper.readValue(content, this.partitionTypeRef);
            return new WorkItemImpl(id, location, content, data);
        }
        catch (Exception ex) {
            return new WorkItemImpl(id, location, "", Maps.newHashMap());
        }
    }
}

