/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal.profile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.locks.LockService;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.partition.TaskContext;
import io.fabric8.partition.WorkItem;
import io.fabric8.partition.Worker;
import io.fabric8.partition.internal.profile.MvelPredicate;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.partition.worker.profile", label="Fabric8 Profile Partition Worker", metatype=false)
@Service(value={Worker.class})
@org.apache.felix.scr.annotations.Properties(value={@Property(name="type", value={"profile-template"})})
public final class ProfileTemplateWorker
extends AbstractComponent
implements Worker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileTemplateWorker.class);
    private static final String ID = "id";
    public static final String TYPE = "profile-template";
    private static final String NAME_VARIABLE_FORMAT = "__%s__";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String PROFILE_WORKER_LOCK = "/fabric/registry/locks/partionworker";
    public static final String TEMPLATE_PROFILE_PROPERTY_NAME = "templateProfile";
    @Property(name="name", label="Container Name", description="The name of the container", value={"${runtime.id}"}, propertyPrivate=true)
    private String name;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=LockService.class)
    private final ValidatingReference<LockService> lockService = new ValidatingReference();
    @GuardedBy(value="this")
    private final Map<Key, CompiledTemplate> templates = new HashMap<Key, CompiledTemplate>();
    @GuardedBy(value="this")
    private final SetMultimap<TaskContext, WorkItem> assignedWorkItems = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    @GuardedBy(value="this")
    private final ParserContext parserContext = new ParserContext();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private InterProcessLock lock;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        this.lock = ((LockService)this.lockService.get()).getLock(PROFILE_WORKER_LOCK);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.destroyInternal();
        this.deactivateComponent();
    }

    private synchronized void destroyInternal() {
        this.stopAll();
    }

    @Override
    public String getType() {
        this.assertValid();
        return TYPE;
    }

    @Override
    public synchronized void assign(TaskContext context, Set<WorkItem> workItems) {
        this.assertValid();
        this.validateTaskContext(context);
        this.executorService.submit(new AssignTask(context, workItems));
    }

    @Override
    public synchronized void release(TaskContext context, Set<WorkItem> workItems) {
        this.assertValid();
        this.validateTaskContext(context);
        this.executorService.submit(new ReleaseTask(context, workItems));
    }

    @Override
    public void stop(TaskContext context) {
        String profileId;
        Container current = ((FabricService)this.fabricService.get()).getCurrentContainer();
        Version version = current.getVersion();
        if (version.hasProfile(profileId = context.getConfiguration().get(TEMPLATE_PROFILE_PROPERTY_NAME) + "-" + this.name)) {
            version.getProfile(profileId).delete(true);
        }
    }

    @Override
    public synchronized void stopAll() {
        for (TaskContext context : this.assignedWorkItems.keySet()) {
            this.stop(context);
        }
        this.templates.clear();
    }

    private void validateTaskContext(TaskContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Task context cannot be null");
        }
        if (context.getConfiguration() == null || context.getConfiguration().isEmpty()) {
            throw new IllegalArgumentException("Task context configuration cannot be null");
        }
        if (!context.getConfiguration().containsKey(TEMPLATE_PROFILE_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Task context configuration: Missing required property: templateProfile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageProfile(TaskContext context) {
        block10: {
            Container current = ((FabricService)this.fabricService.get()).getCurrentContainer();
            ProfileData profileData = this.createProfileData(context);
            String profileId = context.getConfiguration().get(TEMPLATE_PROFILE_PROPERTY_NAME) + "-" + this.name;
            Version version = current.getVersion();
            try {
                if (this.lock.acquire(60L, TimeUnit.SECONDS)) {
                    if (profileData.isEmpty()) {
                        if (version.hasProfile(profileId)) {
                            version.getProfile(profileId).delete(true);
                        }
                        return;
                    }
                    if (!version.hasProfile(profileId)) {
                        ((FabricService)this.fabricService.get()).getDataStore().createProfile(version.getId(), profileId);
                    }
                    Profile managedProfile = version.getProfile(profileId);
                    managedProfile.setFileConfigurations(profileData.getFiles());
                    current.addProfiles(new Profile[]{managedProfile});
                    break block10;
                }
                throw new TimeoutException("Timed out waiting for lock");
            }
            catch (Exception e) {
                LOGGER.error("Error managing work items.", (Throwable)e);
            }
            finally {
                this.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileData createProfileData(TaskContext context) {
        ProfileData profileData = new ProfileData();
        Set workItems = this.assignedWorkItems.get((Object)context);
        if (workItems.isEmpty()) {
            return profileData;
        }
        Container current = ((FabricService)this.fabricService.get()).getCurrentContainer();
        Version version = current.getVersion();
        String templateProfileName = String.valueOf(context.getConfiguration().get(TEMPLATE_PROFILE_PROPERTY_NAME));
        Profile templateProfile = version.getProfile(templateProfileName);
        Set allFiles = templateProfile.getFileConfigurations().keySet();
        Iterable mvelFiles = Iterables.filter(allFiles, (Predicate)MvelPredicate.INSTANCE);
        Iterable plainFiles = Iterables.filter(allFiles, (Predicate)Predicates.not((Predicate)MvelPredicate.INSTANCE));
        for (String mvelFile : mvelFiles) {
            Key key = new Key(templateProfile.getId(), mvelFile);
            Map<Key, CompiledTemplate> map = this.templates;
            synchronized (map) {
                CompiledTemplate template = this.templates.get(key);
                if (template == null) {
                    template = TemplateCompiler.compileTemplate((String)new String((byte[])templateProfile.getFileConfigurations().get(mvelFile)), (ParserContext)this.parserContext);
                    this.templates.put(key, template);
                }
            }
        }
        for (WorkItem workItem : workItems) {
            HashMap<String, WorkItem> data = new HashMap<String, WorkItem>();
            data.put("item", workItem);
            for (String fileTemplate : mvelFiles) {
                String file = this.renderTemplateName(fileTemplate, workItem);
                Key key = new Key(templateProfile.getId(), fileTemplate);
                try {
                    String renderedTemplate = TemplateRuntime.execute((CompiledTemplate)this.templates.get(key), (Object)this.parserContext, data).toString();
                    ProfileTemplateWorker.updateProfileData(file, renderedTemplate, profileData);
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to render {}. Ignoring.", (Object)fileTemplate);
                }
            }
            for (String file : plainFiles) {
                String content = new String((byte[])templateProfile.getFileConfigurations().get(file));
                ProfileTemplateWorker.updateProfileData(file, content, profileData);
            }
        }
        return profileData;
    }

    private void releaseLock() {
        try {
            if (this.lock.isAcquiredInThisProcess()) {
                this.lock.release();
            }
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    private static void updateProfileData(String file, String data, ProfileData profileData) {
        if (file.endsWith(PROPERTIES_SUFFIX)) {
            String pid = file.substring(0, file.length() - PROPERTIES_SUFFIX.length());
            Properties old = new Properties();
            if (profileData.getConfigs().containsKey(pid)) {
                old.putAll(profileData.getConfigs().get(pid));
            }
            Properties merged = ProfileTemplateWorker.mergeProperties(data, old);
            profileData.addPid(pid, ProfileTemplateWorker.toMap(merged));
            profileData.addFile(file, ProfileTemplateWorker.toString(merged).getBytes());
        } else {
            profileData.addFile(file, data.getBytes());
        }
    }

    private String renderTemplateName(String name, WorkItem workItem) {
        for (Map.Entry<String, String> entry : workItem.getData().entrySet()) {
            name = name.replaceAll(String.format(NAME_VARIABLE_FORMAT, "item.data." + entry.getKey()), entry.getValue());
        }
        return name.substring(0, name.lastIndexOf("."));
    }

    private static Properties mergeProperties(Properties left, Properties right) {
        Properties props = new Properties();
        for (String key : left.stringPropertyNames()) {
            props.put(key, left.getProperty(key));
        }
        for (String key : right.stringPropertyNames()) {
            props.put(key, right.getProperty(key));
        }
        return props;
    }

    private static Properties mergeProperties(String left, Properties right) {
        Properties p = new Properties();
        try {
            p.load(new StringReader(left));
        }
        catch (IOException e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        return ProfileTemplateWorker.mergeProperties(p, right);
    }

    private static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    private static String toString(Properties properties) {
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, "");
        }
        catch (IOException e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        return writer.toString();
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindLockService(LockService lockService) {
        this.lockService.bind((Object)lockService);
    }

    void unbindLockService(LockService lockService) {
        this.lockService.unbind((Object)lockService);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    private class ReleaseTask
    implements Runnable {
        private final TaskContext context;
        private final Set<WorkItem> items;

        private ReleaseTask(TaskContext context, Set<WorkItem> items) {
            this.context = context;
            this.items = items;
        }

        @Override
        public void run() {
            try {
                if (this.items.isEmpty()) {
                    return;
                }
                for (WorkItem workItem : this.items) {
                    ProfileTemplateWorker.this.assignedWorkItems.remove((Object)this.context, (Object)workItem);
                }
                ProfileTemplateWorker.this.manageProfile(this.context);
            }
            catch (Exception ex) {
                LOGGER.debug("Error releasing items.", (Throwable)ex);
            }
        }
    }

    private class AssignTask
    implements Runnable {
        private final TaskContext context;
        private final Set<WorkItem> items;

        private AssignTask(TaskContext context, Set<WorkItem> items) {
            this.context = context;
            this.items = items;
        }

        @Override
        public void run() {
            try {
                if (this.items.isEmpty()) {
                    return;
                }
                ProfileTemplateWorker.this.assignedWorkItems.putAll((Object)this.context, this.items);
                ProfileTemplateWorker.this.manageProfile(this.context);
            }
            catch (Exception ex) {
                LOGGER.debug("Error assigning items.", (Throwable)ex);
            }
        }
    }

    private static class ProfileData {
        private final Map<String, byte[]> files = new HashMap<String, byte[]>();
        private final Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();

        private ProfileData() {
        }

        public Map<String, byte[]> getFiles() {
            return this.files;
        }

        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }

        public void addFile(String file, byte[] content) {
            this.files.put(file, content);
        }

        public void addPid(String pid, Map<String, String> config) {
            this.configs.put(pid, config);
        }

        public boolean isEmpty() {
            return this.files.isEmpty() && this.configs.isEmpty();
        }
    }

    private static class Key {
        private final String profile;
        private final String configName;

        private Key(String profile, String configName) {
            this.profile = profile;
            this.configName = configName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            if (this.configName != null ? !this.configName.equals(that.configName) : that.configName != null) {
                return false;
            }
            return !(this.profile != null ? !this.profile.equals(that.profile) : that.profile != null);
        }

        public int hashCode() {
            int result = this.profile != null ? this.profile.hashCode() : 0;
            result = 31 * result + (this.configName != null ? this.configName.hashCode() : 0);
            return result;
        }
    }
}

