/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.osgimetadata;

import io.fabric8.osgimetadata.BaseManagedServiceFactory;
import io.fabric8.osgimetadata.Maven2MetadataProvider;
import io.fabric8.osgimetadata.MavenOsgiMetadataServlet;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import javax.servlet.Servlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;

public class MavenOsgiMetadataProviderFactory
extends BaseManagedServiceFactory<AliasedProvider> {
    private HttpService httpService;

    public MavenOsgiMetadataProviderFactory(BundleContext context) {
        super(context, "MavenOsgiMetadataProviderFactory");
    }

    public void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
        this.execute(new Runnable(){

            @Override
            public void run() {
                for (BaseManagedServiceFactory.Pair service : MavenOsgiMetadataProviderFactory.this.getServices().values()) {
                    AliasedProvider provider = (AliasedProvider)service.getFirst();
                    MavenOsgiMetadataProviderFactory.this.doRegister(provider);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindHttpService(HttpService httpService) throws ExecutionException, InterruptedException {
        if (this.isDestroyed()) {
            return;
        }
        try {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (BaseManagedServiceFactory.Pair service : MavenOsgiMetadataProviderFactory.this.getServices().values()) {
                        AliasedProvider provider = (AliasedProvider)service.getFirst();
                        MavenOsgiMetadataProviderFactory.this.doUnregister(provider);
                    }
                }
            }).get();
        }
        finally {
            this.httpService = null;
        }
    }

    private void doRegister(AliasedProvider provider) {
        try {
            this.httpService.registerServlet(provider.getAlias(), (Servlet)new MavenOsgiMetadataServlet(provider), new Hashtable(), null);
        }
        catch (Exception e) {
            this.LOGGER.warn("Error registering osgi metadata servlet", (Throwable)e);
        }
    }

    private void doUnregister(AliasedProvider provider) {
        try {
            this.httpService.unregister(provider.getAlias());
        }
        catch (Exception e) {
            this.LOGGER.warn("Error unregistering osgi metadata servlet", (Throwable)e);
        }
    }

    @Override
    protected AliasedProvider doCreate(Dictionary<String, ?> properties) throws Exception {
        String alias = this.getString(properties, "alias");
        String path = this.getString(properties, "path");
        String dirs = this.getString(properties, "dirs", "");
        String files = this.getString(properties, "files", "glob:**/*.jar");
        if (alias == null) {
            throw new IllegalArgumentException("Property alias not specified");
        }
        if (path == null) {
            throw new IllegalArgumentException("Property path not specified");
        }
        AliasedProvider provider = new AliasedProvider("/osgimetadata/" + alias, path, dirs, files);
        if (this.httpService != null) {
            this.httpService.registerServlet(provider.getAlias(), (Servlet)new MavenOsgiMetadataServlet(provider), new Hashtable(), null);
        }
        return provider;
    }

    private String getString(Dictionary<String, ?> properties, String name) {
        return this.getString(properties, name, null);
    }

    private String getString(Dictionary<String, ?> properties, String name, String def) {
        Object obj = properties.get(name);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj != null) {
            return obj.toString();
        }
        return def;
    }

    @Override
    protected void doDestroy(AliasedProvider provider) throws Exception {
        provider.destroy();
        if (this.httpService != null) {
            this.httpService.unregister(provider.getAlias());
        }
    }

    @Override
    protected String[] getExposedClasses(AliasedProvider provider) {
        return new String[]{AliasedProvider.class.getName()};
    }

    public static class AliasedProvider
    extends Maven2MetadataProvider {
        private String alias;

        public AliasedProvider(String alias, String root, String dirMatcher, String fileMatcher) throws IOException {
            super(root, dirMatcher, fileMatcher);
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

