/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.osgimetadata;

import io.fabric8.watcher.Processor;
import io.fabric8.watcher.file.FileWatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Maven2MetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(Maven2MetadataProvider.class);
    private static final Set<String> HEADERS = new HashSet<String>(Arrays.asList("Bundle-ManifestVersion", "Bundle-SymbolicName", "Bundle-Version", "Require-Bundle", "Fragment-Host", "Import-Package", "Export-Package", "DynamicImport-Package", "Require-Capability", "Provide-Capability", "Export-Service", "Import-Service"));
    private final Path root;
    private final FileWatcher watcher;
    private final Map<String, Map<String, String>> metadatas = new ConcurrentHashMap<String, Map<String, String>>();

    public Maven2MetadataProvider(String path, String dirMatcher, String fileMatcher) throws IOException {
        this.root = Paths.get(path, new String[0]);
        this.watcher = new FileWatcher();
        this.watcher.setRoot(this.root);
        if (dirMatcher != null && !dirMatcher.isEmpty()) {
            this.watcher.setDirMatchPattern(dirMatcher);
        }
        if (fileMatcher != null && !fileMatcher.isEmpty()) {
            this.watcher.setFileMatchPattern(fileMatcher);
        }
        this.watcher.setProcessor(new Processor(){

            public void process(Path path) {
                Maven2MetadataProvider.this.scan(path);
            }

            public void onRemove(Path path) {
                Maven2MetadataProvider.this.unscan(path);
            }
        });
        this.watcher.init();
    }

    public void destroy() {
        this.watcher.destroy();
    }

    public long getLastModified() {
        return this.watcher.getLastModified();
    }

    public Map<String, Map<String, String>> getMetadatas() {
        return this.metadatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(Path path) {
        try {
            String uri;
            Manifest man;
            try (JarFile jar = new JarFile(path.toFile());){
                man = jar.getManifest();
            }
            if (man == null) {
                return;
            }
            if ("2".equals(man.getMainAttributes().getValue("Bundle-ManifestVersion")) && (uri = this.getResourceUri(path)) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Map.Entry<Object, Object> attr : man.getMainAttributes().entrySet()) {
                    if (!HEADERS.contains(attr.getKey().toString())) continue;
                    headers.put(attr.getKey().toString(), attr.getValue().toString());
                }
                Map prev = this.metadatas.put(uri, headers);
                if (prev == null) {
                    LOGGER.debug("ADD {}", (Object)uri);
                } else {
                    LOGGER.debug("UPD {}", (Object)uri);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Unable to scan resource " + path, (Throwable)e);
        }
    }

    private void unscan(Path file) {
        Map<String, String> prev;
        String uri = this.getResourceUri(file);
        if (uri != null && (prev = this.metadatas.remove(uri)) != null) {
            LOGGER.debug("DEL {}", (Object)uri);
        }
    }

    private String getResourceUri(Path path) {
        return Maven2MetadataProvider.convertToMavenUrl(this.root.relativize(path).toString());
    }

    private static String convertToMavenUrl(String location) {
        String[] p = location.split("/");
        if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
            String artifactId = p[p.length - 3];
            String version = p[p.length - 2];
            String artifactIdVersion = artifactId + "-" + version;
            StringBuilder sb = new StringBuilder();
            String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
            String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
            sb.append("mvn:");
            for (int j = 0; j < p.length - 3; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(p[j]);
            }
            sb.append('/').append(artifactId).append('/').append(version);
            if (!"jar".equals(type) || classifier != null) {
                sb.append('/');
                sb.append(type);
                if (classifier != null) {
                    sb.append('/').append(classifier);
                }
            }
            return sb.toString();
        }
        return null;
    }
}

