/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.osgimetadata;

import io.fabric8.common.util.json.JsonWriter;
import io.fabric8.osgimetadata.Maven2MetadataProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MavenOsgiMetadataServlet
extends HttpServlet {
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String GZIP = "gzip";
    private final Maven2MetadataProvider provider;

    public MavenOsgiMetadataServlet(Maven2MetadataProvider provider) {
        this.provider = provider;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Writer writer;
        resp.setBufferSize(32768);
        resp.setContentType("application/javascript");
        resp.setContentLength(-1);
        String ae = req.getHeader(HEADER_ACCEPT_ENCODING);
        if (ae != null && ae.contains(GZIP)) {
            resp.setHeader(HEADER_CONTENT_ENCODING, GZIP);
            GZIPOutputStream zos = new GZIPOutputStream((OutputStream)resp.getOutputStream(), 32768);
            writer = new BufferedWriter(new OutputStreamWriter(zos));
        } else {
            writer = resp.getWriter();
        }
        JsonWriter.write((Writer)writer, this.provider.getMetadatas());
        ((Writer)writer).close();
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.provider.getLastModified();
    }
}

