/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-import", scope="fabric", description="Downloads the given profile zip(s) and installs them into either the current version or a newly created version.")
public class ProfileImportAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to import the profiles into. Defaults to the current default version if none specified.")
    private String version;
    @Argument(index=0, required=true, multiValued=true, name="profileUrls", description="The URLs for one or more profile ZIP files to install; usually of the form mvn:groupId/artifactId/version/zip/profile")
    @CompleterValues(index=0)
    private List<String> profileUrls;
    private final FabricService fabricService;
    private final ProfileService profileService;

    ProfileImportAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
    }

    protected Object doExecute() throws Exception {
        Version ver;
        Version version = ver = this.version != null ? this.profileService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        if (ver == null) {
            if (this.version != null) {
                System.out.println("Version " + this.version + " does not exist!");
            } else {
                System.out.println("No default version available!");
            }
            return null;
        }
        ((ProfileRegistry)this.fabricService.adapt(ProfileRegistry.class)).importProfiles(ver.getId(), this.profileUrls);
        System.out.println("Imported profiles into version " + ver.getId());
        return null;
    }
}

