/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-delete", scope="fabric", description="Delete the specified version of the specified profile (where the version defaults to the current default version)")
public class ProfileDeleteAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to delete. Defaults to the current default version.")
    private String versionId;
    @Option(name="--force", description="Force the removal of the profile from all assigned containers.")
    private boolean force;
    @Argument(index=0, required=true, name="profile", description="Name of the profile to delete.")
    @CompleterValues(index=0)
    private String name;
    private final FabricService fabricService;

    ProfileDeleteAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateProfileName(this.name);
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        Version version = this.versionId != null ? profileService.getRequiredVersion(this.versionId) : this.fabricService.getRequiredDefaultVersion();
        for (Profile profile : version.getProfiles()) {
            String versionId = profile.getVersion();
            String profileId = profile.getId();
            if (!this.name.equals(profileId)) continue;
            profileService.deleteProfile(this.fabricService, versionId, profileId, this.force);
        }
        return null;
    }
}

