/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.common.util.Strings;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="crypt-password-set", scope="fabric", description="Sets the master password for encryption.")
public class EncryptionMasterPasswordSetAction
extends AbstractAction {
    @Argument(index=0, name="password", description="The master password to set.")
    private String newPassword;
    private final CuratorFramework curator;

    EncryptionMasterPasswordSetAction(CuratorFramework curator) {
        this.curator = curator;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    protected Object doExecute() throws Exception {
        if (Strings.isNotBlank((String)this.newPassword)) {
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]), (String)PasswordEncoder.encode(this.newPassword));
        }
        return null;
    }
}

