/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.FabricService;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="cluster-list", scope="fabric", description="Lists all cluster groups in the fabric")
public class ClusterListAction
extends AbstractAction {
    protected static String CLUSTER_PREFIX = "/fabric/registry/clusters";
    @Argument(required=false, description="Path of the fabric registry node (Zookeeper registry node) to list. Relative paths are evaluated relative to the base node, /fabric/registry/clusters. If not specified, all clusters are listed.")
    String path = "";
    private final FabricService fabricService;
    private final CuratorFramework curator;

    ClusterListAction(FabricService fabricService, CuratorFramework curator) {
        this.fabricService = fabricService;
        this.curator = curator;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    protected Object doExecute() throws Exception {
        String realPath = this.path;
        if (!realPath.startsWith("/")) {
            realPath = CLUSTER_PREFIX;
            if (this.path.length() > 0) {
                realPath = realPath + "/" + this.path;
            }
        }
        this.printCluster(realPath, System.out);
        return null;
    }

    protected void printCluster(String dir, PrintStream out) throws Exception {
        if (ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)dir) == null) {
            return;
        }
        List children = ZooKeeperUtils.getAllChildren((CuratorFramework)this.getCurator(), (String)dir);
        TreeMap clusters = new TreeMap();
        for (String child : children) {
            String text;
            byte[] data = (byte[])this.getCurator().getData().forPath(child);
            if (data == null || data.length <= 0 || (text = new String(data).trim()).isEmpty()) continue;
            String clusterName = this.getClusterName(dir, child);
            TreeMap<String, ClusterNode> cluster = (TreeMap<String, ClusterNode>)clusters.get(clusterName);
            if (cluster == null) {
                cluster = new TreeMap<String, ClusterNode>();
                clusters.put(clusterName, cluster);
            }
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(data, HashMap.class);
            ClusterNode node = null;
            Object id = this.value(map, "id", "container");
            if (id == null) continue;
            Object agent = this.value(map, "container", "agent");
            List services = (List)this.value(map, "services");
            node = (ClusterNode)cluster.get(id);
            if (node == null) {
                node = new ClusterNode();
                cluster.put(id.toString(), node);
            }
            if (services != null) {
                if (!services.isEmpty()) {
                    for (Object service : services) {
                        node.services.add(ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.getCurator(), (String)service.toString()));
                    }
                    node.masters.add(agent);
                    continue;
                }
                node.slaves.add(agent);
                continue;
            }
            node.slaves.add(agent);
        }
        out.println(String.format("%-30s %-30s %-30s %s", "[cluster]", "[masters]", "[slaves]", "[services]"));
        for (String clusterName : clusters.keySet()) {
            Map nodes = (Map)clusters.get(clusterName);
            out.println(String.format("%-30s %-30s %-30s %s", clusterName, "", "", "", ""));
            for (String nodeName : nodes.keySet()) {
                ClusterNode node = (ClusterNode)nodes.get(nodeName);
                out.println(String.format("%-30s %-30s %-30s %s", "   " + nodeName, this.printList(node.masters), this.printList(node.slaves), this.printList(node.services)));
            }
        }
    }

    protected String printList(List list) {
        if (list.isEmpty()) {
            return "-";
        }
        String text = list.toString();
        return text.substring(1, text.length() - 1);
    }

    protected Object value(Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected String getClusterName(String rootDir, String dir) {
        String clusterName = dir;
        if ((clusterName = clusterName.substring(0, clusterName.lastIndexOf("/"))).startsWith(rootDir)) {
            clusterName = clusterName.substring(rootDir.length());
        }
        if (clusterName.startsWith("/")) {
            clusterName = clusterName.substring(1);
        }
        if (clusterName.length() == 0) {
            clusterName = ".";
        }
        return clusterName;
    }

    protected class ClusterNode {
        public List masters = new ArrayList();
        public List services = new ArrayList();
        public List slaves = new ArrayList();

        protected ClusterNode() {
        }

        public String toString() {
            return this.masters + " " + this.services + " " + this.slaves;
        }
    }
}

