/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.commands;

import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftConnectionFactory;
import io.fabric8.openshift.commands.support.OpenshiftConnectionListener;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

public abstract class OpenshiftCommandSupport
extends OsgiCommandSupport {
    @Option(name="--server-url", required=true, description="The url to the openshift server.")
    String serverUrl;
    @Option(name="--login", required=true, description="The login name to use.")
    String login;
    @Option(name="--password", required=true, description="The password to use.")
    String password;
    private final OpenShiftConnectionFactory connectionFactory = new OpenShiftConnectionFactory();
    OpenshiftConnectionListener connectionListener;

    IOpenShiftConnection getOrCreateConnection() {
        IOpenShiftConnection connection = null;
        if (this.connectionListener != null) {
            connection = this.connectionListener.getConnection();
        }
        if (connection == null) {
            connection = this.createConnection();
        }
        return connection;
    }

    IOpenShiftConnection createConnection() {
        return this.connectionFactory.getConnection("fabric", this.login, this.password, this.serverUrl);
    }

    public OpenshiftConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(OpenshiftConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }
}

