/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.commands;

import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.openshift.CreateOpenshiftContainerOptions;
import io.fabric8.openshift.commands.support.ContainerCreateSupport;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.shell.ShellUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="container-create-openshift", scope="fabric", description="Creates one or more new containers on Openshift")
public class ContainerCreateOpenshiftAction
extends ContainerCreateSupport {
    private static final Pattern ALLOWED_NAMES_PATTERN = Pattern.compile("[a-z0-9]+");
    @Option(name="--server-url", required=false, description="The url to the openshift server.")
    String serverUrl;
    @Option(name="--login", required=false, description="The login name to use.")
    String login;
    @Option(name="--password", required=false, description="The password to use.")
    String password;
    @Option(name="--proxy-uri", description="The Maven proxy URL to use")
    private URI proxyUri;
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 0;

    ContainerCreateOpenshiftAction(FabricService fabricService) {
        this.setFabricService(fabricService);
    }

    protected Object doExecute() throws Exception {
        this.validateOpenShiftContainerName(this.name);
        this.preCreateContainer(this.name);
        FabricValidations.validateProfileNames(this.profiles);
        CreateOpenshiftContainerOptions.Builder builder = (CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)CreateOpenshiftContainerOptions.builder().name(this.name)).serverUrl(this.serverUrl).login(this.login).password(this.password).version(this.version)).ensembleServer(this.isEnsembleServer)).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.isEnsembleServer != false && this.zookeeperPassword != null ? this.zookeeperPassword : this.fabricService.getZookeeperPassword())).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI())).profiles(this.getProfileNames())).dataStoreProperties(this.getDataStoreProperties())).dataStoreType(this.dataStoreType != null && this.isEnsembleServer != false ? this.dataStoreType : this.fabricService.getDataStore().getType());
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)builder.build());
        if (this.isEnsembleServer.booleanValue() && metadatas != null && metadatas.length > 0 && metadatas[0].isSuccess()) {
            ShellUtils.storeZookeeperPassword(this.session, metadatas[0].getCreateOptions().getZookeeperPassword());
        }
        this.displayContainers(metadatas);
        return null;
    }

    @Override
    protected void displayContainers(CreateContainerMetadata[] metadatas) {
        ArrayList<CreateContainerMetadata> success = new ArrayList<CreateContainerMetadata>();
        ArrayList failures = new ArrayList();
        for (CreateContainerMetadata metadata : metadatas) {
            (metadata.isSuccess() ? success : failures).add(metadata);
        }
        if (success.size() > 0) {
            System.out.println("The following containers have been created successfully:");
            for (CreateContainerMetadata m : success) {
                System.out.println("\t" + m.toString());
            }
        }
        if (failures.size() > 0) {
            System.out.println("The following containers have failed:");
            for (CreateContainerMetadata m : failures) {
                System.out.println("\t" + m.getContainerName() + ": " + m.getFailure().getMessage());
            }
        }
    }

    protected void validateOpenShiftContainerName(String containerName) {
        boolean valid;
        boolean bl = valid = containerName != null && !containerName.isEmpty() && ALLOWED_NAMES_PATTERN.matcher(containerName).matches();
        if (!valid) {
            throw new IllegalArgumentException("Container name '" + containerName + "' is invalid");
        }
    }
}

