/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.agent;

import io.fabric8.agent.mvn.MavenRepositoryURL;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.common.util.DomHelper;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.common.util.XPathBuilder;
import io.fabric8.common.util.XPathFacade;
import io.fabric8.common.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OpenShiftPomDeployer {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenShiftPomDeployer.class);
    private static final String INDENT = "  ";
    private final Git git;
    private final File baseDir;
    private final String deployDir;
    private final String webAppDir;
    private final String buildWarName = "build";
    private XPathBuilder xpathBuilder = new XPathBuilder();

    public OpenShiftPomDeployer(Git git, File baseDir, String deployDir, String webAppDir) {
        this.git = git;
        this.baseDir = baseDir;
        this.deployDir = deployDir;
        this.webAppDir = webAppDir;
    }

    public void update(Collection<Parser> artifacts, List<MavenRepositoryURL> repos) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, TransformerException, GitAPIException {
        File pom = new File(this.baseDir, "pom.xml");
        Files.assertFileExists((File)pom);
        Document doc = XmlUtils.parseDoc((File)pom);
        Objects.notNull((Object)doc, (String)"xml document");
        Element project = doc.getDocumentElement();
        Objects.notNull((Object)doc, (String)"project element");
        Element dependencies = this.getOrCreateChild(project, "dependencies", 1, true);
        Element repositories = this.getOrCreateChild(project, "repositories", 1, true);
        Element openshiftPlugins = this.getOrCreateOpenShiftProfilePlugins(project);
        this.updateWarPlugin(openshiftPlugins);
        this.updateCleanPlugin(openshiftPlugins);
        this.updateDependencyPlugin(openshiftPlugins, dependencies, artifacts);
        this.updateRepositories(repositories, repos);
        DomHelper.save((Document)doc, (File)pom);
        this.git.add().addFilepattern("pom.xml").call();
    }

    protected void updateWarPlugin(Element plugins) throws XPathExpressionException {
        String textContent;
        Element warName;
        Element plugin = this.getPlugin(plugins, "maven-war-plugin");
        if (plugin != null && (warName = this.xpath("configuration/warName").element((Object)plugin)) != null && Objects.equal((Object)"ROOT", (Object)(textContent = warName.getTextContent()))) {
            warName.setTextContent("build");
        }
    }

    protected void updateCleanPlugin(Element plugins) throws XPathExpressionException {
        Element includes;
        Element fileset;
        Element plugin = this.getOrCreatePlugin(plugins, "maven-clean-plugin", "2.5");
        Element executions = this.getOrCreateChild(plugin, "executions", 6);
        String executionId = "fuse-fabric-clean";
        Element execution = this.xpath("execution[id = '" + executionId + "']").element((Object)executions);
        if (execution == null) {
            execution = this.getOrCreateChild(executions, "execution", 7);
            OpenShiftPomDeployer.createAndAppendChild(execution, "id", 8, executionId);
            OpenShiftPomDeployer.createAndAppendChild(execution, "phase", 9, "initialise");
            Element goals = OpenShiftPomDeployer.createAndAppendChild(execution, "goals", 9);
            OpenShiftPomDeployer.createAndAppendChild(goals, "goal", 10, "clean");
        }
        Element configuration = this.recreateChild(execution, "configuration", 9);
        Element filesets = OpenShiftPomDeployer.createAndAppendChild(configuration, "filesets", 10);
        if (Strings.isNotBlank((String)this.webAppDir)) {
            fileset = OpenShiftPomDeployer.createAndAppendChild(filesets, "fileset", 11);
            OpenShiftPomDeployer.createAndAppendChild(fileset, "directory", 12, "${basedir}/" + this.webAppDir);
            includes = OpenShiftPomDeployer.createAndAppendChild(fileset, "includes", 12);
            OpenShiftPomDeployer.createAndAppendChild(includes, "include", 13, "**/*.war");
        }
        if (Strings.isNotBlank((String)this.deployDir)) {
            fileset = OpenShiftPomDeployer.createAndAppendChild(filesets, "fileset", 11);
            OpenShiftPomDeployer.createAndAppendChild(fileset, "directory", 12, "${basedir}/" + this.deployDir);
            includes = OpenShiftPomDeployer.createAndAppendChild(fileset, "includes", 12);
            OpenShiftPomDeployer.createAndAppendChild(includes, "include", 13, "**/*.jar");
        }
    }

    protected void updateDependencyPlugin(Element plugins, Element dependencies, Collection<Parser> artifacts) throws XPathExpressionException {
        Element plugin = this.getOrCreatePlugin(plugins, "maven-dependency-plugin", "2.8");
        Element executions = this.getOrCreateChild(plugin, "executions", 6);
        ArrayList<Parser> warArtifacts = new ArrayList<Parser>();
        ArrayList<Parser> jarArtifacts = new ArrayList<Parser>();
        for (Parser artifact : artifacts) {
            String type = artifact.getType();
            if (Objects.equal((Object)"war", (Object)type)) {
                warArtifacts.add(artifact);
                continue;
            }
            jarArtifacts.add(artifact);
        }
        if (Strings.isNotBlank((String)this.webAppDir) && !warArtifacts.isEmpty()) {
            this.recreateDependencyExecution(executions, dependencies, "fuse-fabric-deploy-webapps", this.webAppDir, warArtifacts, true);
        }
        if (Strings.isNotBlank((String)this.deployDir) && !jarArtifacts.isEmpty()) {
            this.recreateDependencyExecution(executions, dependencies, "fuse-fabric-deploy-shared", this.deployDir, jarArtifacts, false);
        }
    }

    protected void updateRepositories(Element repositories, List<MavenRepositoryURL> repos) throws XPathExpressionException {
        for (MavenRepositoryURL repo : repos) {
            String url = repo.getURL().toString();
            String id = repo.getId();
            if (!Strings.isNotBlank((String)url)) continue;
            Element repository = this.recreateChild(repositories, "repository[url='" + url + "']", "repository", 2);
            if (Strings.isNotBlank((String)id)) {
                OpenShiftPomDeployer.createAndAppendChild(repository, "id", 3, id);
            }
            OpenShiftPomDeployer.createAndAppendChild(repository, "url", 3, url);
            this.addRepositoryFlag(repository, "releases", repo.isReleasesEnabled());
            this.addRepositoryFlag(repository, "snapshots", repo.isSnapshotsEnabled());
        }
    }

    protected void addRepositoryFlag(Element repository, String flagElementName, boolean flag) {
        Element flagElement = OpenShiftPomDeployer.createAndAppendChild(repository, flagElementName, 3);
        OpenShiftPomDeployer.createAndAppendChild(flagElement, "enabled", 4, flag ? "true" : "false");
    }

    protected Element getOrCreateOpenShiftProfilePlugins(Element project) throws XPathExpressionException {
        Element profile = this.xpath("profiles/profile[id = 'openshift']").element((Object)project);
        if (profile == null) {
            Element profiles = this.getOrCreateChild(project, "profiles", 1, true);
            profile = OpenShiftPomDeployer.createAndAppendChild(profiles, "profile", 2);
            OpenShiftPomDeployer.createAndAppendChild(profile, "id", 3, "openshift");
        }
        Element build = this.getOrCreateChild(profile, "build", 3);
        Element plugins = this.getOrCreateChild(build, "plugins", 4);
        return plugins;
    }

    protected Element recreateDependencyExecution(Element executions, Element dependencies, String executionId, String outputDir, List<Parser> list, boolean isWar) throws XPathExpressionException {
        while (outputDir.startsWith("/")) {
            outputDir = outputDir.substring(1);
        }
        Element execution = this.recreateChild(executions, "execution[id = '" + executionId + "']", "execution", 7);
        OpenShiftPomDeployer.createAndAppendChild(execution, "id", 8, executionId);
        OpenShiftPomDeployer.createAndAppendChild(execution, "phase", 8, "package");
        Element goals = OpenShiftPomDeployer.createAndAppendChild(execution, "goals", 8);
        OpenShiftPomDeployer.createAndAppendChild(goals, "goal", 9, "copy");
        Element configuration = OpenShiftPomDeployer.createAndAppendChild(execution, "configuration", 9);
        Element artifactItems = OpenShiftPomDeployer.createAndAppendChild(configuration, "artifactItems", 10);
        for (Parser parser : list) {
            Element artifactItem = OpenShiftPomDeployer.createAndAppendChild(artifactItems, "artifactItem", 11);
            this.addMavenCoordinates(artifactItem, parser, 12);
            this.addOrUpdateDependency(dependencies, parser);
            OpenShiftPomDeployer.createAndAppendChild(artifactItem, "overWrite", 12, "true");
            OpenShiftPomDeployer.createAndAppendChild(artifactItem, "outputDirectory", 12, "${basedir}/" + outputDir);
            if (!isWar) continue;
            OpenShiftPomDeployer.createAndAppendChild(artifactItem, "destFileName", 12, parser.getArtifact() + ".war");
        }
        OpenShiftPomDeployer.createAndAppendChild(configuration, "outputDirectory", 10, "${basedir}/" + outputDir);
        OpenShiftPomDeployer.createAndAppendChild(configuration, "overWriteReleases", 10, "true");
        OpenShiftPomDeployer.createAndAppendChild(configuration, "overWriteSnapshots", 10, "true");
        return configuration;
    }

    protected void addOrUpdateDependency(Element dependencies, Parser parser) throws XPathExpressionException {
        String classifier;
        String group = OpenShiftPomDeployer.groupId(parser);
        String artifact = parser.getArtifact();
        String xpath = "dependency[groupId = '" + group + "' and artifactId = '" + artifact + "'";
        String type = parser.getType();
        if (Strings.isNotBlank((String)type) && !Objects.equal((Object)"jar", (Object)type)) {
            xpath = xpath + " and type='" + type + "'";
        }
        if (Strings.isNotBlank((String)(classifier = parser.getClassifier()))) {
            xpath = xpath + " and classifier='" + classifier + "'";
        }
        xpath = xpath + "]";
        String scope = "provided";
        Element dependency = this.xpath(xpath).element((Object)dependencies);
        if (dependency != null) {
            scope = this.xpath("scope").elementTextContent((Object)dependency);
            this.detachElement(dependency);
        }
        dependency = OpenShiftPomDeployer.createAndAppendChild(dependencies, "dependency", 2);
        this.addMavenCoordinates(dependency, parser, 3);
        if (Strings.isNotBlank((String)scope)) {
            OpenShiftPomDeployer.createAndAppendChild(dependency, "scope", 3, scope);
        }
    }

    protected void addMavenCoordinates(Element owner, Parser parser, int indent) {
        String classifier;
        String group = OpenShiftPomDeployer.groupId(parser);
        OpenShiftPomDeployer.createAndAppendChild(owner, "groupId", indent, group);
        OpenShiftPomDeployer.createAndAppendChild(owner, "artifactId", indent, parser.getArtifact());
        OpenShiftPomDeployer.createAndAppendChild(owner, "version", indent, parser.getVersion());
        String type = parser.getType();
        if (type != null && !Objects.equal((Object)"jar", (Object)type)) {
            OpenShiftPomDeployer.createAndAppendChild(owner, "type", indent, type);
        }
        if (Strings.isNotBlank((String)(classifier = parser.getClassifier()))) {
            OpenShiftPomDeployer.createAndAppendChild(owner, "classifier", indent, classifier);
        }
    }

    public static String groupId(Parser parser) {
        String group = parser.getGroup();
        int idx = group.indexOf(58);
        if (idx > 0) {
            group = group.substring(idx + 1);
        }
        return group;
    }

    protected Element getOrCreatePlugin(Element plugins, String artifactId, String version) throws XPathExpressionException {
        Element plugin = this.getPlugin(plugins, artifactId);
        if (plugin == null) {
            plugin = OpenShiftPomDeployer.createAndAppendChild(plugins, "plugin", 5);
            OpenShiftPomDeployer.createAndAppendChild(plugin, "artifactId", 6, artifactId);
            OpenShiftPomDeployer.createAndAppendChild(plugin, "version", 6, version);
        }
        return plugin;
    }

    protected Element getPlugin(Element plugins, String artifactId) throws XPathExpressionException {
        return this.xpath("plugin[artifactId = '" + artifactId + "']").element((Object)plugins);
    }

    private Element recreateChild(Element owner, String elementName, int indent) throws XPathExpressionException {
        return this.recreateChild(owner, elementName, elementName, indent);
    }

    private Element recreateChild(Element owner, String xpath, String elementName, int indent) throws XPathExpressionException {
        Element answer = this.xpath(xpath).element((Object)owner);
        if (answer != null) {
            this.detachElement(answer);
        }
        return OpenShiftPomDeployer.createAndAppendChild(owner, elementName, indent);
    }

    protected void detachElement(Element answer) {
        DomHelper.removePreviousSiblingText((Element)answer);
        DomHelper.removeNextSiblingText((Element)answer);
        DomHelper.detach((Node)answer);
    }

    protected Element getOrCreateChild(Element owner, String elementName, int indent, boolean forceWhitespace) throws XPathExpressionException {
        Element answer = this.xpath(elementName).element((Object)owner);
        if (answer == null) {
            answer = OpenShiftPomDeployer.createAndAppendChild(owner, elementName, indent, forceWhitespace);
        }
        return answer;
    }

    protected Element getOrCreateChild(Element owner, String elementName, int indent) throws XPathExpressionException {
        return this.getOrCreateChild(owner, elementName, indent, false);
    }

    public static Element createAndAppendChild(Element owner, String elementName, int indent, String text) {
        Element answer = OpenShiftPomDeployer.createAndAppendChild(owner, elementName, indent);
        if (Strings.isNotBlank((String)text)) {
            OpenShiftPomDeployer.appendText(answer, text);
        }
        return answer;
    }

    public static Element createAndAppendChild(Element owner, String elementName, int indent) {
        return OpenShiftPomDeployer.createAndAppendChild(owner, elementName, indent, false);
    }

    public static Element createAndAppendChild(Element owner, String elementName, int indent, boolean forceWhitespace) {
        Document ownerDocument = owner.getOwnerDocument();
        StringBuilder buffer = new StringBuilder("\n");
        for (int i = 0; i < indent; ++i) {
            buffer.append(INDENT);
        }
        String whitespace = buffer.toString();
        if (forceWhitespace || !OpenShiftPomDeployer.isLastNodeTextWithNewline(owner)) {
            OpenShiftPomDeployer.appendText(owner, whitespace);
        }
        Element newElement = ownerDocument.createElement(elementName);
        owner.appendChild(newElement);
        OpenShiftPomDeployer.appendText(owner, whitespace);
        return newElement;
    }

    private static boolean isLastNodeTextWithNewline(Element owner) {
        Node lastChild = owner.getLastChild();
        if (lastChild instanceof Text) {
            Text textNode = (Text)lastChild;
            String wholeText = textNode.getWholeText();
            return wholeText.contains("\n");
        }
        return false;
    }

    public static Text appendText(Element owner, String text) {
        Document ownerDocument = owner.getOwnerDocument();
        Text textNode = ownerDocument.createTextNode(text);
        owner.appendChild(textNode);
        return textNode;
    }

    protected XPathFacade xpath(String expression) throws XPathExpressionException {
        return this.xpathBuilder.xpath(expression);
    }
}

