/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.agent;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartridgeGitRepository {
    private static final transient Logger LOG = LoggerFactory.getLogger(CartridgeGitRepository.class);
    public static final String DEFAULT_GIT_PATH = File.separator + "git" + File.separator + "fabric-openshift";
    public static final String DEFAULT_LOCAL_LOCATION = System.getProperty("karaf.data") + DEFAULT_GIT_PATH;
    private final File localRepo;
    private String remoteName = "origin";
    private Git git;

    public CartridgeGitRepository(String containerId) {
        this.localRepo = new File(DEFAULT_LOCAL_LOCATION + File.separator + containerId);
    }

    public void cloneOrPull(String repo, CredentialsProvider credentials) throws Exception {
        if (!this.localRepo.exists() && !this.localRepo.mkdirs()) {
            throw new IOException("Failed to create local repository");
        }
        File gitDir = new File(this.localRepo, ".git");
        if (!gitDir.exists()) {
            LOG.info("Cloning remote repo " + repo);
            CloneCommand command = ((CloneCommand)Git.cloneRepository().setCredentialsProvider(credentials)).setURI(repo).setDirectory(this.localRepo).setRemote(this.remoteName);
            this.git = command.call();
        } else {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDir)).readEnvironment()).findGitDir()).build();
            this.git = new Git(repository);
            StoredConfig config = repository.getConfig();
            config.setString("remote", this.remoteName, "url", repo);
            config.setString("remote", this.remoteName, "fetch", "+refs/heads/*:refs/remotes/" + this.remoteName + "/*");
            String branch = "master";
            config.setString("branch", branch, "remote", this.remoteName);
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            try {
                config.save();
            }
            catch (IOException e) {
                LOG.error("Failed to save the git configuration to " + this.localRepo + " with remote repo: " + repo + ". " + e, (Throwable)e);
            }
            LOG.info("Pulling from remote repo " + repo);
            ((PullCommand)this.git.pull().setCredentialsProvider(credentials)).setRebase(true).call();
        }
    }

    public File getLocalRepo() {
        return this.localRepo;
    }

    public Git getGit() throws IOException {
        return this.git;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }
}

