/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift;

import com.openshift.client.IApplication;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftConnectionFactory;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.common.util.Maps;
import io.fabric8.openshift.CreateOpenshiftContainerOptions;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedCartridgeConfig {
    private static final transient Logger LOG = LoggerFactory.getLogger(ManagedCartridgeConfig.class);
    private static final String KEY_DOMAIN = "domain";
    private static final String KEY_LOGIN = "login";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_SERVER_URL = "serverUrl";
    private static boolean substitutedStringValue = false;
    private final Properties properties;

    public static ManagedCartridgeConfig loadConfig(FabricService fabricService, String containerId) throws IOException {
        String propertiesText = fabricService.getDataStore().getContainerAttribute(containerId, DataStore.ContainerAttribute.OpenShift, "", false, substitutedStringValue);
        if (propertiesText == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(propertiesText));
        ManagedCartridgeConfig answer = new ManagedCartridgeConfig(properties);
        LOG.info("Loaded managed cartridge configuration " + answer);
        return answer;
    }

    public static ManagedCartridgeConfig saveConfig(FabricService fabricService, String containerId, CreateOpenshiftContainerOptions options, IApplication application) throws IOException {
        ManagedCartridgeConfig config = new ManagedCartridgeConfig();
        config.setServerUrl(options.getServerUrl());
        config.setLogin(options.getLogin());
        config.setPassword(options.getPassword());
        StringWriter writer = new StringWriter();
        config.getProperties().store(writer, "Saved by " + config.getClass() + " at " + new Date());
        String propertiesText = writer.toString();
        LOG.info("Saved managed cartridge configuration: " + propertiesText);
        fabricService.getDataStore().setContainerAttribute(containerId, DataStore.ContainerAttribute.OpenShift, propertiesText);
        return config;
    }

    public ManagedCartridgeConfig() {
        this(new Properties());
    }

    public ManagedCartridgeConfig(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "ManagedCartridgeConfig(serverUrl: " + this.getServerUrl() + "; login: " + this.getLogin() + ")";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public IOpenShiftConnection createConnection() {
        return new OpenShiftConnectionFactory().getConnection("fabric", this.getLogin(), this.getPassword(), this.getServerUrl());
    }

    public String getLogin() {
        return Maps.stringValue((Map)this.properties, (String)KEY_LOGIN);
    }

    public void setLogin(String login) {
        Maps.setValue((Map)this.properties, (String)KEY_LOGIN, (Object)login);
    }

    public String getPassword() {
        return Maps.stringValue((Map)this.properties, (String)KEY_PASSWORD);
    }

    public void setPassword(String password) {
        Maps.setValue((Map)this.properties, (String)KEY_PASSWORD, (Object)password);
    }

    public String getServerUrl() {
        return Maps.stringValue((Map)this.properties, (String)KEY_SERVER_URL);
    }

    public void setServerUrl(String serverUrl) {
        Maps.setValue((Map)this.properties, (String)KEY_SERVER_URL, (Object)serverUrl);
    }

    public String getDomain() {
        return Maps.stringValue((Map)this.properties, (String)KEY_DOMAIN);
    }

    public void setDomain(String serverUrl) {
        Maps.setValue((Map)this.properties, (String)KEY_DOMAIN, (Object)serverUrl);
    }
}

