/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateRemoteContainerOptions;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CreateOpenshiftContainerOptions
extends CreateContainerBasicOptions<CreateOpenshiftContainerOptions>
implements CreateRemoteContainerOptions {
    private static final long serialVersionUID = 4489740280396972109L;
    public static String OPENSHIFT_BROKER_HOST = "OPENSHIFT_BROKER_HOST";
    public static String OPENSHIFT_NAMESPACE = "OPENSHIFT_NAMESPACE";
    @JsonProperty
    private final String serverUrl;
    @JsonProperty
    private final String login;
    @JsonProperty
    private final String password;
    @JsonProperty
    private final String domain;
    @JsonProperty
    private final String gearProfile;
    @JsonProperty
    private final Map<String, String> environmentalVariables;

    public static Builder builder() {
        return new Builder();
    }

    public CreateOpenshiftContainerOptions(String bindAddress, String resolver, String globalResolver, String manualIp, int minimumPort, int maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, int zooKeeperServerPort, int zooKeeperServerConnectionPort, String zookeeperPassword, boolean ensembleStart, boolean agentEnabled, boolean autoImportEnabled, String importPath, Map<String, String> users, String name, String parent, String providerType, boolean ensembleServer, String preferredAddress, Map<String, Properties> systemProperties, Integer number, URI proxyUri, String zookeeperUrl, String jvmOpts, boolean adminAccess, boolean clean, String serverUrl, String login, String password, String domain, String gearProfile, Map<String, String> environmentalVariables) {
        super(bindAddress, resolver, globalResolver, manualIp, minimumPort, maximumPort, profiles, version, dataStoreProperties, zooKeeperServerPort, zooKeeperServerConnectionPort, zookeeperPassword, ensembleStart, agentEnabled, false, 0L, autoImportEnabled, importPath, users, name, parent, providerType, ensembleServer, preferredAddress, systemProperties, number, proxyUri, zookeeperUrl, jvmOpts, adminAccess, clean);
        this.serverUrl = serverUrl;
        this.login = login;
        this.password = password;
        this.domain = domain;
        this.gearProfile = gearProfile;
        this.environmentalVariables = environmentalVariables;
    }

    public CreateOpenshiftContainerOptions updateCredentials(String user, String credential) {
        return new CreateOpenshiftContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "openshift", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.isClean(), this.serverUrl, user, this.password, this.domain, this.gearProfile, this.environmentalVariables);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getGearProfile() {
        return this.gearProfile;
    }

    public String getHostNameContext() {
        return "openshift";
    }

    public String getPath() {
        return "~/";
    }

    public Map<String, String> getEnvironmentalVariables() {
        return this.environmentalVariables;
    }

    public static class Builder
    extends CreateContainerBasicOptions.Builder<Builder> {
        @JsonProperty
        private String serverUrl = System.getenv(OPENSHIFT_BROKER_HOST);
        @JsonProperty
        private String login;
        @JsonProperty
        private String password;
        @JsonProperty
        private String domain = System.getenv(OPENSHIFT_NAMESPACE);
        @JsonProperty
        private String gearProfile = "small";
        @JsonProperty
        private Map<String, String> environmentalVariables = new HashMap<String, String>();

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder login(String login) {
            this.login = login;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder gearProfile(String gearProfile) {
            this.gearProfile = gearProfile;
            return this;
        }

        public Builder environmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
            return this;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public String getLogin() {
            return this.login;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public Map<String, String> getEnvironmentalVariables() {
            return this.environmentalVariables;
        }

        public void setEnvironmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
        }

        public CreateOpenshiftContainerOptions build() {
            return new CreateOpenshiftContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "openshift", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.isClean(), this.serverUrl, this.login, this.password, this.domain, this.gearProfile, this.environmentalVariables);
        }
    }
}

