/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.hadoop;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ContainerCompleter;
import io.fabric8.boot.commands.support.ParameterCompleter;
import io.fabric8.commands.hadoop.CreateAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"hadoop"}), @Property(name="osgi.command.function", value={"create"})})
public final class Create
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "hadoop";
    public static final String FUNCTION_VALUE = "create";
    public static final String DESCRIPTION = "Create an Hadoop cluster";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindNameNodeContainerCompleter", unbind="unbindNameNodeContainerCompleter")
    private ContainerCompleter nameNodeContainerCompleter;
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindDataNodeContainerCompleter", unbind="unbindDataNodeContainerCompleter")
    private ContainerCompleter dataNodeContainerCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new CreateAction((FabricService)this.fabricService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindNameNodeContainerCompleter(ContainerCompleter completer) {
        this.bindOptionalCompleter("--name-node", (Completer)completer);
    }

    void unbindNameNodeContainerCompleter(ContainerCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }

    void bindDataNodeContainerCompleter(ContainerCompleter completer) {
        this.bindOptionalCompleter("--data-nodes", (Completer)completer);
    }

    void unbindDataNodeContainerCompleter(ContainerCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }
}

