/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.IHttpClient;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClient;

public class UrlConnectionHttpClientBuilder {
    private String userAgent;
    private boolean sslChecks = false;
    private String username;
    private String password;
    private String authKey;
    private String authIV;
    private String acceptedMediaType;
    private String version;

    public UrlConnectionHttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public UrlConnectionHttpClientBuilder setSSLChecks(boolean check) {
        this.sslChecks = check;
        return this;
    }

    public UrlConnectionHttpClientBuilder setCredentials(String username, String password) {
        return this.setCredentials(username, password, null, null);
    }

    public UrlConnectionHttpClientBuilder setCredentials(String username, String password, String authKey, String authIV) {
        this.username = username;
        this.password = password;
        this.authKey = authKey;
        this.authIV = authIV;
        return this;
    }

    public UrlConnectionHttpClientBuilder setAcceptMediaType(String mediaType) {
        this.acceptedMediaType = mediaType;
        return this;
    }

    public UrlConnectionHttpClientBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public IHttpClient client() {
        return new UrlConnectionHttpClient(this.username, this.password, this.userAgent, this.sslChecks, this.acceptedMediaType, this.version, this.authKey, this.authIV);
    }
}

