/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.GitContext;
import io.fabric8.git.PullPushPolicy;
import io.fabric8.git.internal.GitHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPullPushPolicy
implements PullPushPolicy {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DefaultPullPushPolicy.class);
    private final Git git;
    private final String remoteRef;
    private final int gitTimeout;

    DefaultPullPushPolicy(Git git, String remoteRef, int gitTimeout) {
        this.git = git;
        this.remoteRef = remoteRef;
        this.gitTimeout = gitTimeout;
    }

    @Override
    public synchronized PullPushPolicy.PullPolicyResult doPull(GitContext context, CredentialsProvider credentialsProvider, boolean allowVersionDelete) {
        Repository repository = this.git.getRepository();
        StoredConfig config = repository.getConfig();
        String remoteUrl = config.getString("remote", this.remoteRef, "url");
        if (remoteUrl == null) {
            LOGGER.info("No remote repository defined, so not doing a pull");
            return new AbstractPullPolicyResult();
        }
        LOGGER.info("Performing a pull on remote URL: {}", (Object)remoteUrl);
        GitAPIException lastException = null;
        try {
            ((FetchCommand)((FetchCommand)this.git.fetch().setTimeout(this.gitTimeout)).setCredentialsProvider(credentialsProvider)).setRemote(this.remoteRef).call();
        }
        catch (GitAPIException ex) {
            lastException = ex;
        }
        if (lastException != null) {
            LOGGER.warn("Pull failed because of: {}", (Object)lastException.toString());
            return new AbstractPullPolicyResult(lastException);
        }
        HashMap<String, Ref> localBranches = new HashMap<String, Ref>();
        HashMap<String, Ref> remoteBranches = new HashMap<String, Ref>();
        HashSet<String> allBranches = new HashSet<String>();
        try {
            Iterator i$ = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().iterator();
            while (i$.hasNext()) {
                String name;
                Ref ref = (Ref)i$.next();
                if (ref.getName().startsWith("refs/remotes/" + this.remoteRef + "/")) {
                    name = ref.getName().substring(("refs/remotes/" + this.remoteRef + "/").length());
                    remoteBranches.put(name, ref);
                    allBranches.add(name);
                    continue;
                }
                if (!ref.getName().startsWith("refs/heads/")) continue;
                name = ref.getName().substring("refs/heads/".length());
                localBranches.put(name, ref);
                allBranches.add(name);
            }
            boolean localUpdate = false;
            boolean remoteUpdate = false;
            TreeSet<String> versions = new TreeSet<String>();
            if (remoteBranches.isEmpty()) {
                LOGGER.info("Pulled from an empty remote repository");
                return new AbstractPullPolicyResult(versions, false, !localBranches.isEmpty(), null);
            }
            LOGGER.info("Processing remote branches: {}", remoteBranches);
            IllegalStateAssertion.assertTrue((Boolean)remoteBranches.containsKey("master"), (String)"Remote repository does not have a master branch");
            if (localBranches.containsKey("master")) {
                this.git.checkout().setName("master").setForce(true).call();
            }
            for (String branch : allBranches) {
                String remoteCommit;
                boolean allowDelete;
                boolean bl = allowDelete = allowVersionDelete && !"master".equals(branch);
                if (localBranches.containsKey(branch) && !remoteBranches.containsKey(branch)) {
                    if (allowDelete) {
                        LOGGER.info("Deleting local branch: {}", (Object)branch);
                        this.git.branchDelete().setBranchNames(branch).setForce(true).call();
                        localUpdate = true;
                        continue;
                    }
                    remoteUpdate = true;
                    continue;
                }
                if (!localBranches.containsKey(branch) && remoteBranches.containsKey(branch)) {
                    LOGGER.info("Adding local branch: {}", (Object)branch);
                    this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(this.remoteRef + "/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setForce(true).call();
                    versions.add(branch);
                    localUpdate = true;
                    continue;
                }
                if (!localBranches.containsKey(branch) || !remoteBranches.containsKey(branch)) continue;
                ObjectId localObjectId = ((Ref)localBranches.get(branch)).getObjectId();
                ObjectId remoteObjectId = ((Ref)remoteBranches.get(branch)).getObjectId();
                String localCommit = localObjectId.getName();
                if (!localCommit.equals(remoteCommit = remoteObjectId.getName())) {
                    this.git.clean().setCleanDirectories(true).call();
                    this.git.checkout().setName("HEAD").setForce(true).call();
                    this.git.checkout().setName(branch).setForce(true).call();
                    MergeResult mergeResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.FF_ONLY).include(remoteObjectId).call();
                    MergeResult.MergeStatus mergeStatus = mergeResult.getMergeStatus();
                    LOGGER.info("Updating local branch {} with status: {}", (Object)branch, (Object)mergeStatus);
                    if (mergeStatus == MergeResult.MergeStatus.FAST_FORWARD) {
                        localUpdate = true;
                    } else if (mergeStatus == MergeResult.MergeStatus.ALREADY_UP_TO_DATE) {
                        remoteUpdate = true;
                    } else if (mergeStatus == MergeResult.MergeStatus.ABORTED) {
                        LOGGER.info("Cannot fast forward branch {}, attempting rebase", (Object)branch);
                        RebaseResult rebaseResult = this.git.rebase().setUpstream(remoteCommit).call();
                        RebaseResult.Status rebaseStatus = rebaseResult.getStatus();
                        if (rebaseStatus == RebaseResult.Status.OK) {
                            localUpdate = true;
                            remoteUpdate = true;
                        } else {
                            LOGGER.info("Rebase on branch {} failed, restoring remote branch", (Object)branch);
                            this.git.rebase().setOperation(RebaseCommand.Operation.ABORT).call();
                            this.git.checkout().setName("master").setForce(true).call();
                            this.git.branchDelete().setBranchNames(branch).setForce(true).call();
                            this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(this.remoteRef + "/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setForce(true).call();
                            localUpdate = true;
                        }
                    }
                }
                versions.add(branch);
            }
            AbstractPullPolicyResult result = new AbstractPullPolicyResult(versions, localUpdate, remoteUpdate, null);
            LOGGER.info("Pull result: {}", (Object)result);
            return result;
        }
        catch (Exception ex) {
            return new AbstractPullPolicyResult(ex);
        }
    }

    @Override
    public synchronized PullPushPolicy.PushPolicyResult doPush(GitContext context, CredentialsProvider credentialsProvider) {
        StoredConfig config = this.git.getRepository().getConfig();
        String remoteUrl = config.getString("remote", this.remoteRef, "url");
        if (remoteUrl == null) {
            LOGGER.info("No remote repository defined, so not doing a push");
            return new AbstractPushPolicyResult();
        }
        LOGGER.info("Pushing last change to: {}", (Object)remoteUrl);
        Iterator resit = null;
        GitAPIException lastException = null;
        try {
            resit = ((PushCommand)((PushCommand)this.git.push().setTimeout(this.gitTimeout)).setCredentialsProvider(credentialsProvider)).setPushAll().call().iterator();
        }
        catch (GitAPIException ex) {
            lastException = ex;
        }
        if (lastException != null) {
            LOGGER.warn("Cannot push because of: {}", (Object)lastException.toString());
            return new AbstractPushPolicyResult(lastException);
        }
        ArrayList<PushResult> pushResults = new ArrayList<PushResult>();
        ArrayList<RemoteRefUpdate> acceptedUpdates = new ArrayList<RemoteRefUpdate>();
        ArrayList<RemoteRefUpdate> rejectedUpdates = new ArrayList<RemoteRefUpdate>();
        while (resit.hasNext()) {
            PushResult pushResult = (PushResult)resit.next();
            pushResults.add(pushResult);
            for (RemoteRefUpdate refUpdate : pushResult.getRemoteUpdates()) {
                RemoteRefUpdate.Status status = refUpdate.getStatus();
                if (status == RemoteRefUpdate.Status.OK || status == RemoteRefUpdate.Status.UP_TO_DATE) {
                    acceptedUpdates.add(refUpdate);
                    continue;
                }
                rejectedUpdates.add(refUpdate);
            }
        }
        for (RemoteRefUpdate rejectedRef : rejectedUpdates) {
            LOGGER.warn("Rejected push: {}" + rejectedRef);
            String refName = rejectedRef.getRemoteName();
            String branch = refName.substring(refName.lastIndexOf(47) + 1);
            try {
                GitHelpers.checkoutBranch(this.git, branch);
                FetchResult fetchResult = ((FetchCommand)((FetchCommand)this.git.fetch().setTimeout(this.gitTimeout)).setCredentialsProvider(credentialsProvider)).setRemote(this.remoteRef).setRefSpecs(new RefSpec("refs/heads/" + branch)).call();
                Ref fetchRef = fetchResult.getAdvertisedRef("refs/heads/" + branch);
                this.git.branchRename().setOldName(branch).setNewName(branch + "-tmp").call();
                this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(fetchRef.getObjectId().getName()).call();
                this.git.branchDelete().setBranchNames(branch + "-tmp").setForce(true).call();
            }
            catch (GitAPIException ex) {
                LOGGER.warn("Cannot reset branch {}, because of: {}", (Object)branch, (Object)ex.toString());
            }
        }
        AbstractPushPolicyResult result = new AbstractPushPolicyResult(pushResults, acceptedUpdates, rejectedUpdates, lastException);
        LOGGER.info("Push result: {}", (Object)result);
        return result;
    }

    static class AbstractPushPolicyResult
    implements PullPushPolicy.PushPolicyResult {
        private final List<PushResult> pushResults = new ArrayList<PushResult>();
        private final List<RemoteRefUpdate> acceptedUpdates = new ArrayList<RemoteRefUpdate>();
        private final List<RemoteRefUpdate> rejectedUpdates = new ArrayList<RemoteRefUpdate>();
        private final Exception lastException;

        AbstractPushPolicyResult() {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
        }

        AbstractPushPolicyResult(Exception lastException) {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), lastException);
        }

        AbstractPushPolicyResult(List<PushResult> pushResults, List<RemoteRefUpdate> acceptedUpdates, List<RemoteRefUpdate> rejectedUpdates, Exception lastException) {
            this.pushResults.addAll(pushResults);
            this.acceptedUpdates.addAll(acceptedUpdates);
            this.rejectedUpdates.addAll(rejectedUpdates);
            this.lastException = lastException;
        }

        @Override
        public List<PushResult> getPushResults() {
            return Collections.unmodifiableList(this.pushResults);
        }

        @Override
        public List<RemoteRefUpdate> getAcceptedUpdates() {
            return Collections.unmodifiableList(this.acceptedUpdates);
        }

        @Override
        public List<RemoteRefUpdate> getRejectedUpdates() {
            return Collections.unmodifiableList(this.rejectedUpdates);
        }

        @Override
        public Exception getLastException() {
            return this.lastException;
        }

        public String toString() {
            return "[accepted=" + this.acceptedUpdates.size() + ",rejected=" + this.rejectedUpdates.size() + ",error=" + this.lastException + "]";
        }
    }

    static class AbstractPullPolicyResult
    implements PullPushPolicy.PullPolicyResult {
        private final Set<String> versions = new TreeSet<String>();
        private final boolean localUpdate;
        private final boolean remoteUpdate;
        private final Exception lastException;

        AbstractPullPolicyResult() {
            this(Collections.emptySet(), false, false, null);
        }

        AbstractPullPolicyResult(Exception lastException) {
            this(Collections.emptySet(), false, false, lastException);
        }

        AbstractPullPolicyResult(Set<String> versions, boolean localUpdate, boolean remoteUpdate, Exception lastException) {
            this.versions.addAll(versions);
            this.localUpdate = localUpdate;
            this.remoteUpdate = remoteUpdate;
            this.lastException = lastException;
        }

        @Override
        public boolean localUpdateRequired() {
            return this.localUpdate;
        }

        @Override
        public boolean remoteUpdateRequired() {
            return this.remoteUpdate;
        }

        @Override
        public Set<String> getVersions() {
            return Collections.unmodifiableSet(this.versions);
        }

        @Override
        public Exception getLastException() {
            return this.lastException;
        }

        public String toString() {
            return "[localUpdate=" + this.localUpdate + ",remoteUpdate=" + this.remoteUpdate + ",versions=" + this.versions + ",error=" + this.lastException + "]";
        }
    }
}

