/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.api.DataStore;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.FabricException;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.visibility.VisibleForTesting;
import io.fabric8.git.GitProxyService;
import io.fabric8.git.GitService;
import io.fabric8.git.internal.GitContext;
import io.fabric8.git.internal.GitDataStore;
import io.fabric8.git.internal.GitOperation;
import io.fabric8.utils.DataStoreUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gitective.core.CommitUtils;

@ThreadSafe
@Component(name="io.fabric8.datastore", label="Fabric8 Caching Git DataStore", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@References(value={@Reference(referenceInterface=DataStoreRegistrationHandler.class, bind="bindRegistrationHandler", unbind="unbindRegistrationHandler"), @Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator"), @Reference(referenceInterface=GitService.class, bind="bindGitService", unbind="unbindGitService"), @Reference(referenceInterface=GitProxyService.class, bind="bindGitProxyService", unbind="unbindGitProxyService"), @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")})
@Service(value={DataStore.class})
@Properties(value={@Property(name="type", value={"caching-git"})})
public final class CachingGitDataStore
extends GitDataStore {
    public static final String TYPE = "caching-git";
    @Reference
    private Configurer configurer;
    @GuardedBy(value="LoadingCache")
    private final LoadingCache<String, VersionData> cachedVersions = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, VersionData>(){

        public VersionData load(final String version) throws Exception {
            return CachingGitDataStore.this.gitOperation(new GitOperation<VersionData>(){

                @Override
                public VersionData call(Git git, GitContext context) throws Exception {
                    VersionData data = new VersionData();
                    CachingGitDataStore.this.populateVersionData(git, version, data);
                    CachingGitDataStore.this.populateVersionData(git, "master", data);
                    return data;
                }
            }, true);
        }
    });

    @VisibleForTesting
    @Activate
    public void activate(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        this.protectedActivate(configuration);
    }

    @Deactivate
    void deactivate() {
        this.protectedDeactivate();
    }

    protected VersionData getVersionData(String version) {
        this.assertValid();
        VersionData data = null;
        try {
            data = (VersionData)this.cachedVersions.get((Object)version);
        }
        catch (ExecutionException e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        return data;
    }

    protected void populateVersionData(Git git, String branch, VersionData data) throws Exception {
        File[] files;
        this.assertValid();
        this.checkoutVersion(git, branch);
        File profilesDir = this.getProfilesDirectory(git);
        if (profilesDir.exists() && (files = profilesDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.addProfileData(git, branch, data, file, "");
            }
        }
    }

    private void addProfileData(Git git, String version, VersionData data, File file, String prefix) throws IOException {
        String profile = file.getName();
        if (!profile.endsWith(".profile")) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    if (!child.isDirectory()) continue;
                    this.addProfileData(git, version, data, child, prefix + file.getName() + "-");
                }
            }
            return;
        }
        profile = prefix + profile.substring(0, profile.length() - ".profile".length());
        String revision = git.getRepository().getRefDatabase().getRef(version).getObjectId().getName();
        String path = this.convertProfileIdToDirectory(profile);
        RevCommit commit = CommitUtils.getLastCommit(git.getRepository(), revision, CONFIGS_PROFILES + File.separator + path);
        String lastModified = commit != null ? commit.getId().abbreviate(7).name() : "";
        Map<String, byte[]> configurations = this.doGetFileConfigurations(git, profile);
        HashMap<String, Map<String, String>> substituted = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, byte[]> entry : configurations.entrySet()) {
            if (!entry.getKey().endsWith(".properties")) continue;
            String pid = DataStoreUtils.stripSuffix(entry.getKey(), ".properties");
            substituted.put(pid, DataStoreUtils.toMap(DataStoreUtils.toProperties(entry.getValue())));
        }
        ProfileData profileData = new ProfileData(lastModified, Collections.unmodifiableMap(configurations), Collections.unmodifiableMap(substituted));
        data.profiles.put(profile, profileData);
    }

    @Override
    public List<String> getProfiles(String version) {
        this.assertValid();
        VersionData v = this.getVersionData(version);
        return v != null && v.profiles != null ? new ArrayList<String>(v.profiles.keySet()) : new ArrayList<String>();
    }

    public boolean hasProfile(String version, String profile) {
        this.assertValid();
        VersionData v = this.getVersionData(version);
        ProfileData p = v != null && v.profiles != null ? v.profiles.get(profile) : null;
        return p != null;
    }

    @Override
    public String getLastModified(String version, String profile) {
        this.assertValid();
        VersionData v = this.getVersionData(version);
        ProfileData p = v != null && v.profiles != null ? v.profiles.get(profile) : null;
        return p != null ? p.lastModified : "";
    }

    @Override
    public byte[] getFileConfiguration(String version, String profile, String fileName) {
        this.assertValid();
        VersionData v = this.getVersionData(version);
        ProfileData p = v != null && v.profiles != null ? v.profiles.get(profile) : null;
        return p != null && p.files != null ? p.files.get(fileName) : null;
    }

    @Override
    public Map<String, byte[]> getFileConfigurations(String version, String profile) {
        this.assertValid();
        VersionData v = this.getVersionData(version);
        ProfileData p = v != null && v.profiles != null ? v.profiles.get(profile) : null;
        return p != null ? new HashMap<String, byte[]>(p.files) : Collections.emptyMap();
    }

    public Map<String, Map<String, String>> getConfigurations(String version, String profile) {
        this.assertValid();
        VersionData v = this.getVersionData(version);
        ProfileData p = v != null && v.profiles != null ? v.profiles.get(profile) : null;
        return p != null ? new HashMap<String, Map<String, String>>(p.configs) : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getConfiguration(String version, String profile, String pid) {
        this.assertValid();
        Map<String, Map<String, String>> configs = this.getConfigurations(version, profile);
        if (configs.containsKey(pid)) {
            return new HashMap<String, String>(configs.get(pid));
        }
        return new HashMap<String, String>();
    }

    @Override
    void removeVersion(String version) {
        super.removeVersion(version);
        this.cachedVersions.invalidate((Object)version);
    }

    protected void clearCaches() {
        this.assertValid();
        this.cachedVersions.invalidateAll();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @VisibleForTesting
    public void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    void unbindConfigurer(Configurer configurer) {
        this.configurer = null;
    }

    private static class ProfileData {
        final String lastModified;
        final Map<String, byte[]> files;
        final Map<String, Map<String, String>> configs;

        ProfileData(String lastModified, Map<String, byte[]> files, Map<String, Map<String, String>> configs) {
            this.lastModified = lastModified;
            this.files = files;
            this.configs = configs;
        }
    }

    private static class VersionData {
        final Map<String, ProfileData> profiles = new HashMap<String, ProfileData>();

        private VersionData() {
        }
    }
}

