/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import javaewah.EWAHCompressedBitmap;
import javaewah.IntIterator;

final class InflatingBitSet {
    private static final long[] EMPTY = new long[0];
    private final EWAHCompressedBitmap bitmap;
    private IntIterator iterator;
    private long[] inflated;
    private int nextPosition = -1;
    private final int sizeInBits;

    InflatingBitSet(EWAHCompressedBitmap bitmap) {
        this(bitmap, EMPTY);
    }

    private InflatingBitSet(EWAHCompressedBitmap orBitmap, long[] inflated) {
        this.bitmap = orBitmap;
        this.inflated = inflated;
        this.sizeInBits = this.bitmap.sizeInBits();
    }

    final boolean maybeContains(int position) {
        if (this.get(position)) {
            return true;
        }
        return this.nextPosition <= position && position < this.sizeInBits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean contains(int position) {
        if (this.get(position)) {
            return true;
        }
        if (position <= this.nextPosition || position >= this.sizeInBits) {
            if (position != this.nextPosition) return false;
            return true;
        }
        if (this.iterator == null) {
            this.iterator = this.bitmap.intIterator();
            if (!this.iterator.hasNext()) return false;
            this.nextPosition = this.iterator.next();
        } else if (!this.iterator.hasNext()) {
            return false;
        }
        int positionBlock = InflatingBitSet.block(position);
        if (positionBlock >= this.inflated.length) {
            long[] tmp = new long[InflatingBitSet.block(this.sizeInBits) + 1];
            System.arraycopy(this.inflated, 0, tmp, 0, this.inflated.length);
            this.inflated = tmp;
        }
        int block = InflatingBitSet.block(this.nextPosition);
        long word = InflatingBitSet.mask(this.nextPosition);
        int end = Math.max(this.nextPosition, position) | 0x3F;
        while (this.iterator.hasNext()) {
            this.nextPosition = this.iterator.next();
            if (end < this.nextPosition) break;
            int b = InflatingBitSet.block(this.nextPosition);
            long m = InflatingBitSet.mask(this.nextPosition);
            if (block == b) {
                word |= m;
                continue;
            }
            this.inflated[block] = word;
            block = b;
            word = m;
        }
        this.inflated[block] = word;
        if (block != positionBlock) return false;
        if ((word & InflatingBitSet.mask(position)) == 0L) return false;
        return true;
    }

    private final boolean get(int position) {
        int b = InflatingBitSet.block(position);
        return b < this.inflated.length && (this.inflated[b] & InflatingBitSet.mask(position)) != 0L;
    }

    private static final int block(int position) {
        return position >> 6;
    }

    private static final long mask(int position) {
        return 1L << position;
    }

    private final boolean isEmpty() {
        return this.sizeInBits == 0;
    }

    final InflatingBitSet or(EWAHCompressedBitmap other) {
        if (other.sizeInBits() == 0) {
            return this;
        }
        return new InflatingBitSet(this.bitmap.or(other), this.inflated);
    }

    final InflatingBitSet andNot(EWAHCompressedBitmap other) {
        if (this.isEmpty()) {
            return this;
        }
        return new InflatingBitSet(this.bitmap.andNot(other));
    }

    final InflatingBitSet xor(EWAHCompressedBitmap other) {
        if (this.isEmpty()) {
            if (other.sizeInBits() == 0) {
                return this;
            }
            return new InflatingBitSet(other);
        }
        return new InflatingBitSet(this.bitmap.xor(other));
    }

    final EWAHCompressedBitmap getBitmap() {
        return this.bitmap;
    }
}

