/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.git.GitNode;
import io.fabric8.git.GitService;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.utils.Closeables;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.net.URL;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.git.master.listener", label="Fabric8 Git Master Listener", immediate=true, metatype=false)
public final class GitMasterListener
extends AbstractComponent
implements GroupListener<GitNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitMasterListener.class);
    @Reference(referenceInterface=GitService.class)
    private final ValidatingReference<GitService> gitService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=ContainerRegistration.class)
    private final ValidatingReference<ContainerRegistration> containerRegistration = new ValidatingReference();
    private Group<GitNode> group;

    @Activate
    void activate() throws IOException {
        this.activateComponent();
        this.group = new ZooKeeperGroup((CuratorFramework)this.curator.get(), ZkPath.GIT.getPath(new String[0]), GitNode.class);
        this.group.add((GroupListener)this);
        this.group.start();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.group.remove((GroupListener)this);
        Closeables.closeQuitely(this.group);
    }

    public void groupEvent(Group<GitNode> group, GroupListener.GroupEvent event) {
        if (this.isValid()) {
            switch (event) {
                case CONNECTED: 
                case CHANGED: {
                    this.updateMasterUrl(group);
                }
            }
        }
    }

    private void updateMasterUrl(Group<GitNode> group) {
        GitNode master = (GitNode)group.master();
        String masterUrl = master != null ? master.getUrl() : null;
        try {
            if (masterUrl != null) {
                GitService gitservice = (GitService)this.gitService.get();
                String substitutedUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)masterUrl);
                if (!Strings.isNotBlank(substitutedUrl)) {
                    LOGGER.warn("Could not render git master URL {}.", (Object)masterUrl);
                }
                URL url = new URL(substitutedUrl);
                gitservice.notifyRemoteChanged(substitutedUrl);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to point origin to the new master.", (Throwable)e);
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindGitService(GitService service) {
        this.gitService.bind((Object)service);
    }

    void unbindGitService(GitService service) {
        this.gitService.unbind((Object)service);
    }

    void bindContainerRegistration(ContainerRegistration service) {
        this.containerRegistration.bind((Object)service);
    }

    void unbindContainerRegistration(ContainerRegistration service) {
        this.containerRegistration.unbind((Object)service);
    }
}

