/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.Check;
import org.gitective.core.filter.commit.CommitFilter;

public class CommitterDiffFilter
extends CommitFilter {
    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        PersonIdent author = commit.getAuthorIdent();
        PersonIdent committer = commit.getCommitterIdent();
        if (author != null && committer != null) {
            return this.isSamePerson(author, committer) ? this.include(false) : true;
        }
        if (author == null && committer == null) {
            return this.include(false);
        }
        return true;
    }

    protected boolean isSamePerson(PersonIdent author, PersonIdent committer) {
        return Check.equals(author.getName(), committer.getName()) && Check.equals(author.getEmailAddress(), committer.getEmailAddress());
    }

    public RevFilter clone() {
        return new CommitterDiffFilter();
    }
}

